/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgFourierPad.c                                               */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:44 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "FourierPad"
#define ERROR(e) imgError(e,PRGNAME)

int main(int argc,char **argv)
{
  it_image *in,*out;
  int width,height,size,temp,xx,yy,x,y,xoff,yoff;
  double val,min,max;
  it_float *ptr;

  IFHELP
    {
      fprintf(stderr,"img%s - Pad convolution kernel into a Fourier sized kernel\n", 
	      PRGNAME);
      fprintf(stderr,"img%s size\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: Float, Double\n");
      fprintf(stderr,"  stdout: Float\n");
      fprintf(stderr,"  size is the output image dimension (must be a power of two)\n");
      exit(0);
    }

  imgStart(PRGNAME);

  if(argc!=2)
    ERROR("size argument must be specified");

  size=atoi(argv[1]);
  for(temp=size;(temp&1)==0;temp>>=1);
  if(temp!=1)
    ERROR("size argument must be a power of two");

  do {
    in=i_read_image_file(stdin,IT_FLOAT | IT_DOUBLE,IM_FRAGMENT);
    if(in==NULL)
      ERROR("can't import image file");
    width=in->width;
    height=in->height;

    out=i_create_image(size,size,IT_FLOAT,IM_CONTIG);
    if(out==NULL)
      ERROR("out of memory");
    
    xoff=size-(width-1)/2;
    yoff=size-(height-1)/2;
    if(in->type==IT_FLOAT)
      {
	for(y=0;y<height;y++)
	  {
	    yy=(y+yoff)%size;
	    if(yy>=0 && yy<size)
	      for(x=0;x<width;x++)
		{
		  xx=(x+xoff)%size;
		  if(xx>=0 && xx<size)
		    im_float_value(out,xx,yy)=im_float_value(in,x,y);
		}
	  }
      }
    else
      {
	for(y=0;y<height;y++)
	  {
	    yy=(y+yoff)%size;
	    if(yy>=0 && yy<size)
	      for(x=0;x<width;x++)
		{
		  xx=(x+xoff)%size;
		  if(xx>=0 && xx<size)
		    im_float_value(out,xx,yy)=im_double_value(in,x,y);
		}
	  }
      }

    imgInitMinMax(min,max);
    ptr=im_float_row(out,0);
    for(temp=0;temp<size*size;temp++)
      {
	val= *ptr++;
	if(val<min) min=val;
	if(val>max) max=val;
      }
    out->min_value=min;
    out->max_value=max;

    i_destroy_image(in);
    i_write_image_file(stdout,out,IF_BINARY);
    i_destroy_image(out);
  } while(!feof(stdin));

  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
