/* structs.c */
/* Copyright 1988 John M. Sullivan.  See main program for details. */
/**** functions to allocate and manipulate data structures ****/

/***** External functions
void init_site(s,p): initializes fields in a site
facet_edge make_wing(s1,s2,s3): makes a wing between the three sites
corner new_corner(s0,s1,s2,s3): makes a voronoi vertex for the 4 sites
corner inf_vert(s1,s2,s3): makes a voronoi vertex at infinity
void link_wings(f1,f2,c): links these wings into a single edge loop
***** Lower level
void link_edge_loops(f1,f2,c), reverse_edge_loop(f): used by link_wings
*****/

#include "vcs.h"

void
init_site(s,p)
site s;
point p;
{
    s->loc = p;
    s->color = 0;
    s->one_fe = NULL;
    s->cnst_q = NULL;
    s->flag = FALSE;
    s->volume = 0.;
}

facet_edge
make_wing(s0,s1,s2)
site s0,s1,s2;
{
    register facet_edge f;
    register int i,j;

    f = mem_alloc(3,facet_edge);
    N_DTri++;

    (f+1)->cell[0] = f->cell[1] = s0;
    (f+2)->cell[0] = (f+1)->cell[1] = s1;
    f->cell[0] = (f+2)->cell[1] = s2;

    for (i=0;i<3;i++)
    {
	for (j=0; j<2; j++)
	{
	    (f+i)->nfacet[j] = f + (i+2-j)%3;
	    (f+i)->nedge[j] = f+i;
	    (f+i)->vert[j] = NULL;
	}
	(f+i)->fi = NULL;
	(f+i)->seq_num = 0;
	unmark(f+i);
    }

    return f;
}

void
link_edge_loops(f,g,c)
facet_edge f,g;
corner c;
/* makes f and g be in the same facet--their
nedge loops are spliced with g just after f */
/* the corner c is the one between f and g */
{
    g->prevedge->nextedge = f->nextedge;
    f->nextedge->prevedge = g->prevedge;
    f->nextedge = g; /* = old value of g->prevedge->nextedge */
    g->prevedge = f;

    f->vert[1] = g->vert[0] = c;

    DBG(3, print_fe(f); print_fe(g); printf("linked\n\n");)
}

void
link_wings(f,g,c)
register facet_edge f,g;
corner c;
/* takes two wings, finds the parts that should be adjacent, then links */
{
    register int i;

    while(find(f->cell[0],g))
	f=f->nextfacet;
    f=f->nextfacet;

    while(find(g->cell[0],f))
	g=g->nextfacet;
    g=g->nextfacet;

    for (i=0; i<2; i++)
	if (f->nedge[i] == g)	/* if already linked (through inf) */
	{
	    f->vert[i] = g->vert[1-i] = c;
	    return;		/* just fill in vertex between them */
	}

    if (f->vert[1]==0 && g->vert[0]==0)
	link_edge_loops(f,g,c);
    else if (f->vert[0]==0 && g->vert[1]==0)
	link_edge_loops(g,f,c);
    else
    {
	if (f->vert[1]==0 && g->vert[1]==0)
	    link_edge_loops(f,reverse_edge_loop(g),c);
	else if (f->vert[0]==0 && g->vert[0]==0)
	    link_edge_loops(reverse_edge_loop(f),g,c);
	else
	    error("edges impossible to link");
    }
}

facet_edge
reverse_edge_loop(f)
facet_edge f;
/* this goes in and switches nedge[01] and vert[01] in f's edge loop */
/* then returns changed f */
{
    for_edges(f,e)
	swap(corner,e->vert[0],e->vert[1]);
	swap(facet_edge,e->nedge[0],e->nedge[1]);
    end_edges(f,e)
    return f;
}

corner
new_corner(s0,s1,s2,s3)
register site s0,s1,s2,s3;
{
    corner c;
    struct point tmp;
    real vol;
    int i;

    c = mem_alloc(1,corner);
    N_DTet++;
    c->cell[0] = s0;
    c->cell[1] = s1;
    c->cell[2] = s2;
    c->cell[3] = s3;
    c->seq_num = 0;

    unless(s0->color == s1->color && s0->color == s2->color &&
	   s0->color == s1->color && s0->color == s3->color)
	s0->flag = s1->flag = s2->flag = s3->flag = TRUE;
    vol = -2*volume(s0->loc,s1->loc,s2->loc,s3->loc);
    c->deriv[0] = area(s1->loc,s2->loc,s3->loc);
    c->deriv[1] = area(s0->loc,s3->loc,s2->loc);
    c->deriv[2] = area(s3->loc,s0->loc,s1->loc);
    c->deriv[3] = area(s2->loc,s1->loc,s0->loc);

    /*c->loc = voronoi_corner(s0->loc, s1->loc, s2->loc, s3->loc);*/
    c->loc = pt(0,0,0);
    for (i=0;i<4;i++)
    {
	divide_x(c->deriv[i],vol,c->deriv[i]);
	sum_x(c->loc,scalar_x(-norm2(c->cell[i]->loc),c->deriv[i],&tmp),c->loc);
    }
    /* now if si moves to si+ds, c will move to c+ 2((c-si).ds)cderiv[i] */
    return c;
}

corner
inf_vert(wing,dir)
facet_edge wing;
int dir;
{
    point p1,p2,p3;
    register corner c;
    struct point tmp;

    c = mem_alloc(1,corner);
    c->one_fe = wing;
    c->seq_num = 0;
    N_BndryTri++;
    c->cell[0] = NULL;
    p1 = (c->cell[1] = wing->cell[1-dir]) -> loc;
    p2 = (c->cell[2] = wing->cell[dir]) -> loc;
    p3 = (c->cell[3] = wing->nfacet[dir]->cell[dir]) -> loc;
    /* go out far in the right general direction */
    /* take vor_corner to get exactly on the right line */
    c->loc = voronoi_corner(scalar_x(INFTY,area_x(p1, p2, p3, &tmp),&tmp),
			    p1, p2, p3);
    return c;
}
