/* Copyright 1988 John M. Sullivan.  See main program for details. */
/* this file has info about the facet edge data structure */
/* types site and corner must be defined before this file is included */

typedef
struct face_info
{
	struct point fi_un;
	real area;
	real height;
	int which_wulff;
	real wulff_energy;
	int seq_num;
}
* face_info;

#define unit_normal(f) (&(f)->fi->fi_un)
#define wulff_vect(f) (&Wulff_Vect[(f)->fi->which_wulff])

/* The following structure, facet_edge, will consist of four
neighboring facet_edges, two sites, and two vertices, all of
which are associated to the given facet - edge pair.      */

/* The nedge[1] pointers point in a consistent direction around the
edges of a facet; nedge[0] point backwards.  f->vert[i] is the vertex
shared by f and f->nedge[i].  Exactly the same conventions hold for
cell[i] and nfacet[i].  There is no assumption about right or left
handedness of the two loops in any one facet_edge.	*/

/* To keep the above conventions valid, we must allow that in an
nedge loop (where all the facet_edges are between the same two cells)
the identity of cell[0] and cell[1] may switch.  (And the same for vert[i]
in an nfacet loop.)					*/

typedef
struct    facet_edge
{
	site   cell[2];
	corner	vert[2];
	struct	facet_edge *nedge[2], *nfacet[2];
	bool seen; /* mark if seen yet when tracing faces */
	face_info fi;
	int seq_num;
}
* facet_edge;

/* alternate names for the facet_edge links */
#define nextedge nedge[1]
#define prevedge nedge[0]
#define nextfacet nfacet[1]
#define prevfacet nfacet[0]

/* definitions to handle marking and unmarking the 'seen' bit */
#define marked(fe) ((fe)->seen)
#define unmarked(fe) (!marked(fe))
#define mark(fe) (marked(fe) = TRUE)
#define unmark(fe) (marked(fe) = FALSE)
#define toggle(fe) (marked(fe) = !marked(fe));

/* looping construct to follow around edges of one facet */
#define for_edges(fe,e)						\
			{					\
			    register facet_edge e=fe;		\
			    do					\
			    {
#define end_edges_dir(fe,e,x)					\
			    }					\
			    while ((e=e->nedge[x]) != fe);		\
			}
#define end_edges(fe,e) end_edges_dir(fe,e,1)
#define end_reverse_edges(fe,e) end_edges_dir(fe,e,0)
#define for_other_edges(fe,e) for_edges(fe->nextedge,e)

/* looping construct to follow around facets of one edge */
#define for_facets(fe,f)					\
			{					\
			    register facet_edge f=fe;		\
			    do					\
			    {
#define end_facets_dir(fe,f,x)					\
			    }					\
			    while ((f=f->nfacet[x]) != fe);	\
			}
#define end_facets(fe,f) end_facets_dir(fe,f,1);
#define for_other_facets(fe,f) for_facets(fe->nextfacet,f)

/* swing out from f to adjacent f_e still next to site s */
#define swing(f,s) (s==f->cell[0]? f->nfacet[0] : f->nfacet[1])
/* swing to fe *not* next to s */
#define swing_out(f,s) (s==f->cell[0]? f->nfacet[1] : f->nfacet[0])
/* get other cell */
#define other_cell(f,s) (s==f->cell[0]? f->cell[1] : f->cell[0])

/* edge swing out to adjacent f_e still next to corner c */
/* ie find other edge of facet with one end at c */
#define eswing(f,c) (c==f->vert[0]? f->nedge[0] : f->nedge[1])
/* swing to fe *not* next to c, ie go in opposite direction */
#define eswing_out(f,s) (c==f->vert[0]? f->nedge[1] : f->nedge[0])

/* special macros for manipulating wings */
#define cell_2_ nextfacet->cell[1]
/* is a site one of the ones around a wing? */
#define find(s,w) (s==w->cell[0] || s==w->cell[1] || s==w->cell_2_)
/* not quite as useful since facets may have many edges: */
#define vert_2_ nextedge->vert[1]
