/****
   util.c:  Utility routines for "omni_interp"
   Written by Toby Orloff and Jim Larson
   orloff@poincare.geom.umn.edu
   September 18, 1990
****/

/*
 * Copyright (c) 1990, Geometry Supercomputer Project
 *                     University of Minnesota
 *                     1200 Washington Ave. S
 *                     Minneapolis, MN  55415
 *
 * email address: software@geom.umn.edu
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */

#include <stdio.h>
#include "types.h"
#include "globals.h"


/*	This function checks whether a string is an acceptable piece of
 *	data.  Usually, it only accepts numbers which cannot be interpreted
 *	as integers (i.e., decimal point or exponentiation).  If the
 *	integer flag is 1, all numbers are accepted.
 */

is_a_float (strng)
     char *strng;
{
  char *ch;
  int passes, is_an_int;
  double val;

  /* Check if convertible to floating point number */

  passes = 1;
  is_an_int = 1;			/* Until otherwise determined */

  val = strtod (strng,&ch);
  if (*ch != '\0')			/* Not correct format */
    passes = 0;

  if (integer)				/* Regard integers as floating point */
    is_an_int = 0;
  else					/* Check to see if its an integer */
    {
      ch = strng;
      while (*ch != '\0' && passes)
	{
	  switch (*ch)
	    {
	    case '.':
	    case 'e':
	    case 'E':
	      is_an_int = 0;
	      ch++;
	      break;

	    default:
	      ch++;
	    }
	}
    }

  if (passes == 1 && is_an_int == 0)
    return (1);
  else
    return (0);
}


/*	The following error routines print a message to stderr and exit
 *	with a positive code.
 */

MemError ()
{
  fprintf (stderr, "%s:  Fatal error - out of memory!\n", progname);
  exit (1);
}


OpenError (filename)
     char *filename;
{
  fprintf (stderr, "%s:  Fatal error - cannot open %s!\n",
	   progname, filename);
  exit (2);
}


ReadError (filename, fp)
     char *filename;
     FILE *fp;
{
  fprintf (stderr, "%s:  Fatal error - incorrect read on file %s!\n",
	   progname, filename);
  fclose (fp);
  exit (3);
}

