/****
   window.c:  sample user-defined interpolation function
   Written by Toby Orloff and Jim Larson
   orloff@poincare.geom.umn.edu
   September 18, 1990
****/

/*
 * Copyright (c) 1990, Geometry Supercomputer Project
 *                     University of Minnesota
 *                     1200 Washington Ave. S
 *                     Minneapolis, MN  55415
 *
 * email address: software@geom.umn.edu
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */


#include "omni_interp.h"


/*	This function makes a neat transition between two still
 *	images.  It shows the first image, and then transforms into
 *	the second image by opening up a small window in the center
 *	of the first image through which the second image is visible.
 *	This window then grows to fill the whole screen.
 *
 *	Parameters:
 *		A - Width of screen in pixels
 *		B - Height of screen in pixels
 *	(A pixel is assumed to be a three-byte value - RGB format)
 */

/* Circular window. */

void
user_interp (time, in , out, file_pos, data_pos)
     double time;			/* Time of this interpolation. */
     double **in;			/* Input data. */
     double *out;			/* Interpolated data. */
     int file_pos;			/* Position of this data chunk */
					/* in whole data file. */
     int data_pos;			/* Position of this interpolation */
					/* time among data indices. */
{
  int x, y;

  /* Calculate position of current pixel. */

  x = (file_pos / 3) % ((int) A);
  y = (file_pos / 3) / ((int) A);

  /* Are we inside the window at this time? */

  if ((x - ((int) A)/2) * (x - ((int) A)/2)
      + (y - ((int) B)/2) * (y - ((int) B)/2)
      < time * time * (A * A + B * B) / 4.0) 
    {
      out[0] = in[1][0];
      out[1] = in[1][1];
      out[2] = in[1][2];
    }
  else
    {
      out[0] = in[0][0];
      out[1] = in[0][1];
      out[2] = in[0][2];
    }
}

#ifdef UNDEFINED

/* Square window. */

void
user_interp (time, in , out, file_pos, data_pos)
     double time;			/* Time of this interpolation. */
     double **in;			/* Input data. */
     double *out;			/* Interpolated data. */
     int file_pos;			/* Position of this data chunk */
					/* in whole data file. */
     int data_pos;			/* Position of this interpolation */
					/* time among data indices. */
{
  int x, y;

  /* Calculate position of current pixel. */

  x = (file_pos / 3) % ((int) A);
  y = (file_pos / 3) / ((int) A);

  /* Are we inside the window at this time? */

  if (abs (x - ((int) A)/2) < time * A/2.0
      && abs (y - ((int) B)/2) < time * B/2.0)
    {
      out[0] = in[1][0];
      out[1] = in[1][1];
      out[2] = in[1][2];
    }
  else
    {
      out[0] = in[0][0];
      out[1] = in[0][1];
      out[2] = in[0][2];
    }
}
#endif UNDEFINED
