/****
   bounded.c:  sample user-defined interpolation function
   Written by Toby Orloff and Jim Larson
   orloff@poincare.geom.umn.edu
   September 18, 1990
****/

/*
 * Copyright (c) 1990, Geometry Supercomputer Project
 *                     University of Minnesota
 *                     1200 Washington Ave. S
 *                     Minneapolis, MN  55415
 *
 * email address: software@geom.umn.edu
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */


#include "omni_interp.h"


/*	This interpolation is simply cubic splines with derivative 0 at
 *	all data points.  This is to provide step-wise interpolation
 *	without the discontinuities of linear interpolation.
 */

void
user_interp (time, in, out, file_pos, data_pos)
     double time;
     double **in;
     double *out;
     int file_pos;
     int data_pos;
{
  double len;				/* Length of this interval. */
  double x, x2, x3;
  int i;

  if (time == in_time [data_pos])
    {
      for (i = 0; i < data_chunk; i++)
	out [i] = in [data_pos][i];
      return;
    }

  len = in_time [data_pos + 1] - in_time [data_pos];
  x = (time - in_time [data_pos]) / len;
  x2 = x * x;
  x3 = x2 * x;

  for (i = 0; i < data_chunk; i++)
    {
      out [i] = in [data_pos][i] * (2*x3 - 3*x2 + 1)
	+ in [data_pos + 1][i] * (-2*x3 + 3*x2);
    }
}


      
      
