#include <stdio.h>
#include <X11/Xlib.h>
#include "link_types.h"
#include "link_global.h"

LinkList *LinkCreateNewLink(status)
VOID *status;

{
  LinkStatus *gnrc;
  LinkList *lnk;

  gnrc = (LinkStatus *) status;
  lnk = &(gnrc->link);
  while(lnk->next != NULL) lnk = lnk->next;
  lnk->next = (LinkList *) malloc(sizeof(LinkList));
  if((lnk = lnk->next) == NULL) {
     fprintf(stderr,"Warning:  unable to allocate new link.\n");
     return(NULL);
    }

  lnk->next = NULL;
  lnk->point.next = NULL;
  lnk->visible = LINK_YES;
  lnk->closed = LINK_NO;
  lnk->num = 0;
  gnrc->current_link = lnk;
  gnrc->num++;
  return(lnk);
}

LinkModeNone(status)

VOID *status;  
{
  LinkStatus *gnrc;
  gnrc = (LinkStatus *) status;
  gnrc->choice[0] = LINK_NO_CHOICE;
}

LinkModeAddPoint(status)

VOID *status;  
{
  LinkStatus *gnrc;
  gnrc = (LinkStatus *) status;
  gnrc->choice[0] = LINK_ADD_POINT;
  LinkPrintMessage(gnrc,"Click to add point.");
}

LinkModeDeletePoint(status)

VOID *status;  
{
  LinkStatus *gnrc;
  gnrc = (LinkStatus *) status;
  gnrc->choice[0] = LINK_DELETE_POINT;
  LinkPrintMessage(gnrc,"Click to delete point.");
}

LinkModeMovePoint(status)

VOID *status;  
{
  LinkStatus *gnrc;
  gnrc = (LinkStatus *) status;
  gnrc->choice[0] = LINK_MOVE_POINT;
  LinkPrintMessage(gnrc,"Click and drag to move point.");
}

LinkModeSelectLink(status)
VOID *status;  
{
  LinkStatus *gnrc;
  gnrc = (LinkStatus *) status;
  gnrc->choice[0] = LINK_SELECT_LINK;
  LinkPrintMessage(gnrc,"Click to select strand.");
}

LinkModeHideLink(status)

VOID *status;  
{
  LinkStatus *gnrc;
  gnrc = (LinkStatus *) status;
  gnrc->choice[0] = LINK_HIDE_LINK;
}

LinkModeTranslateLink(status)

VOID *status;  
{
  LinkStatus *gnrc;
  gnrc = (LinkStatus *) status;
  gnrc->choice[0] = LINK_TRANSLATE_LINK;
  LinkPrintMessage(gnrc,"Click and drag to translate strand.");
}

LinkModeRotateLink(status)

VOID *status;  
{
  LinkStatus *gnrc;
  gnrc = (LinkStatus *) status;
  gnrc->choice[0] = LINK_ROTATE_LINK;
  LinkPrintMessage(gnrc,"Sorry, rotating is not yet implemented.");
}

LinkModeScaleLink(status)

VOID *status;  
{
  LinkStatus *gnrc;
  gnrc = (LinkStatus *) status;
  gnrc->choice[0] = LINK_SCALE_LINK;
  LinkPrintMessage(gnrc,"Sorry, scaling is not yet implemented.");
}

LinkModeShiftView(status)

VOID *status;  
{
  LinkStatus *gnrc;
  gnrc = (LinkStatus *) status;
  gnrc->choice[0] = LINK_SHIFT_VIEW;
  LinkPrintMessage(gnrc,"Click and drag to shift view.");
}

LinkModeFlipCrossing(status)

VOID *status;  
{
  LinkStatus *gnrc;
  gnrc = (LinkStatus *) status;
  gnrc->choice[0] = LINK_FLIP_CROSSING;
  LinkPrintMessage(gnrc,"Click to flip crossing.");
}

LinkModeZoomView(status)

VOID *status;  
{
  LinkStatus *gnrc;
  gnrc = (LinkStatus *) status;
  gnrc->choice[0] = LINK_ZOOM_VIEW;
  LinkPrintMessage(gnrc,"Click and drag to zoom view.");
}

LinkModeJoinLinks(status)

VOID *status;  
{
  LinkStatus *gnrc;
  gnrc = (LinkStatus *) status;
  gnrc->choice[0] = LINK_JOIN_SELECT_HEAD;
  LinkPrintMessage(gnrc,"Select end of first strand.");
}

LinkModeReverseArrows(status)

VOID *status;  
{
  LinkStatus *gnrc;
  gnrc = (LinkStatus *) status;
  gnrc->choice[0] = LINK_REVERSE_ARROWS;
  LinkPrintMessage(gnrc,"Select strand to reverse.");
}

LinkModeCloseStrand(status)
VOID *status;  
{
  LinkStatus *gnrc;
  gnrc = (LinkStatus *) status;
  gnrc->choice[0] = LINK_CLOSE_LINK;
  LinkPrintMessage(gnrc,"Select strand to close.");
}

LinkModeOpenStrand(status)
VOID *status;  
{
  LinkStatus *gnrc;
  gnrc = (LinkStatus *) status;
  gnrc->choice[0] = LINK_OPEN_LINK;
  LinkPrintMessage(gnrc,"Select strand to open.");
}

LinkModeDeleteStrand(status)
VOID *status;  
{
  LinkStatus *gnrc;
  gnrc = (LinkStatus *) status;
  gnrc->choice[0] = LINK_DELETE_LINK;
  LinkPrintMessage(gnrc,"Select strand to delete.");
}


LinkShowXRuler(status)

VOID *status;
{
  LinkStatus *gnrc;
  gnrc = (LinkStatus *) status;
  gnrc->xruler = LINK_SHOW;
}


LinkShowYRuler(status)

VOID *status;
{
  LinkStatus *gnrc;
  gnrc = (LinkStatus *) status;
  gnrc->yruler = LINK_SHOW;
}


LinkHideXRuler(status)

VOID *status;
{
  LinkStatus *gnrc;
  gnrc = (LinkStatus *) status;
  gnrc->xruler = LINK_HIDE;
}


LinkHideYRuler(status)

VOID *status;
{
  LinkStatus *gnrc;
  gnrc = (LinkStatus *) status;
  gnrc->yruler = LINK_HIDE;
}

LinkPublicReDraw(status)
VOID *status;  
{
  LinkStatus *gnrc;
  gnrc = (LinkStatus *) status;
  XClearWindow(dpy,gnrc->TopWindow);
  ReDrawLinkTopWindow(gnrc);
}

LinkPublicClear(status)
VOID *status;
{
  LinkStatus *gnrc;
  gnrc = (LinkStatus *) status;
  XClearWindow(dpy,gnrc->TopWindow);
  LinkClearData(gnrc);
}

LinkOpenCurrentLink(status)
VOID *status;
{
  LinkStatus *gnrc;
  LinkList *lnk;
  LinkPointList *pnt;

  gnrc = (LinkStatus *) status;
  lnk = gnrc->current_link;
  if(lnk == NULL) {
     LinkPrintMessage(gnrc,"No currently selected link.");
     return;
    }
  if(!lnk->closed) {
     LinkPrintMessage(gnrc,"Link is already open.");
     return;
    }
  lnk->closed = 0;

  /* find last point */
  pnt = &(lnk->point);
  if(pnt->next == NULL) {
     LinkPrintMessage(gnrc,"Link is empty!");
     return;
    }
  while(pnt->next != NULL) pnt = pnt->next;

  LinkFreeEdgeCrossings(gnrc,lnk,pnt);
  XClearWindow(dpy,gnrc->TopWindow);
  ReDrawLinkTopWindow(gnrc);

}

LinkCloseCurrentLink(status)
VOID *status;
{
  LinkStatus *gnrc;
  LinkList *lnk;
  LinkPointList *pnt;

  gnrc = (LinkStatus *) status;
  lnk = gnrc->current_link;
  if(lnk == NULL) {
     LinkPrintMessage(gnrc,"No currently selected strand.");
     return;
    }
  if(lnk->closed) {
     LinkPrintMessage(gnrc,"Strand is already closed.");
     return;
    }
  if(lnk->num < 3) {
     LinkPrintMessage(gnrc,"Too few points to close strand!");
     return;
    }
  /* find last point */
  pnt = &(lnk->point);
  if(pnt->next == NULL) {
     LinkPrintMessage(gnrc,"Link is empty!");
     return;
    }
  lnk->closed = 1;
  while(pnt->next != NULL) pnt = pnt->next;
  LinkComputeEdgeCrossings(gnrc,lnk,pnt);
  XClearWindow(dpy,gnrc->TopWindow);
  ReDrawLinkTopWindow(gnrc);
}

LinkPublicPrintMessage(status,mssg)

VOID *status;
char *mssg;

{
  LinkStatus *gnrc;

  gnrc = (LinkStatus *) status;
  LinkPrintMessage(gnrc,mssg);
}

LinkPublicUrgentWindowDialogue(status,prmpt,rtrn)

VOID *status;
char *prmpt,*rtrn;

{
  LinkStatus *gnrc;
  int num;

  gnrc = (LinkStatus *) status;
  num = LinkUrgentWindowDialogue(gnrc,prmpt,rtrn);
  return(num);
}

LinkShowAll(status)

VOID *status;
{
  LinkStatus *gnrc;
  LinkList *lnk;

  gnrc = (LinkStatus *) status;
  lnk = gnrc->link.next;
  while(lnk != NULL) {
     lnk->visible = LINK_SHOW;
     lnk = lnk->next;
    }
  XClearWindow(dpy,gnrc->TopWindow);
  ReDrawLinkTopWindow(gnrc);
}

LinkDeleteCurrentSelection(status)
VOID *status;
{
  LinkStatus *gnrc;

  gnrc = (LinkStatus *) status;
  LinkDeleteLink(gnrc,gnrc->current_link);
}

LinkPublicDeleteAll(status)
VOID *status;
{
  LinkStatus *gnrc;

  gnrc = (LinkStatus *) status;
  LinkDeleteAll(gnrc);
}

LinkSetAxes(status,set)
VOID *status; int set;
{
  LinkStatus *gnrc;
  gnrc = (LinkStatus *) status;
  gnrc->axes = set;
}

LinkSetArrows(status,set)
VOID *status; int set;
{
  LinkStatus *gnrc;
  gnrc = (LinkStatus *) status;
  gnrc->arrows = set;
}

LinkSetVertices(status,set)
VOID *status; int set;
{
  LinkStatus *gnrc;
  gnrc = (LinkStatus *) status;
  gnrc->vertices = set;
}

LinkSetRulers(status,set)
VOID *status; int set;
{
  LinkStatus *gnrc;
  gnrc = (LinkStatus *) status;
  gnrc->xruler = set;
  gnrc->yruler = set;
}

LinkSaveAll(status,name)
VOID *status; char *name;
/* returns 0 if successful */
{
  char strng[160];
  FILE *fp;
  LinkList *lnk;
  LinkPointList *pnt;
  LinkCrossingList *crssng;
  int lnk_id,pnt_id,num_crssng;

  LinkStatus *gnrc;
  gnrc = (LinkStatus *) status;

  fp = fopen(name,"w");
  if(fp == NULL) {
    sprintf(strng,"Cannot open file %s\n",name);
    LinkPrintMessage(gnrc,strng);
    return(-1);
   }
  fprintf(fp,"LINK_PROJECTION\n");
  
  /* Save strand data */
  lnk = gnrc->link.next;
  lnk_id = 0;
  while(lnk != NULL) {
     fprintf(fp," Strand %d\n",lnk_id);
     LinkPrintLink(gnrc,fp,lnk);
     /* Set id's while we're at it...*/
     lnk->id = lnk_id;
     lnk_id++;
     lnk = lnk->next;
    }

  /* set link_id for each point */
  lnk = gnrc->link.next;
  while(lnk != NULL) {
     lnk_id = lnk->id;
     pnt = lnk->point.next;
     pnt_id = 0;
     while(pnt != NULL) {
        pnt->link_id = lnk_id;
        pnt->point_id = pnt_id;
        pnt_id++;
        pnt = pnt->next;
       }
     lnk = lnk->next;
    }

  /* Save crossing data */
  fprintf(fp,"# crossing format: \n");
  fprintf(fp,"#    UpLinkID EdgeID   DownLinkID EdgeID   UpParam DownParam\n");

  /* Count number of over crossings */
  lnk = gnrc->link.next;
  num_crssng = 0;
  while(lnk != NULL) {
     pnt = lnk->point.next;
     while(pnt != NULL) {
        crssng = pnt->crossing.next;
        while(crssng != NULL) {
           if(crssng->z > 0.0) { /* Over crossing */
              num_crssng++;
             }
           crssng = crssng->next;
          }
        pnt = pnt->next;
       }
     lnk = lnk->next;
    }
  fprintf(fp," Crossings %d\n",num_crssng);
  /* save only over crossings- under crossing implicit */
  lnk = gnrc->link.next;
  while(lnk != NULL) {
     pnt = lnk->point.next;
     while(pnt != NULL) {
        crssng = pnt->crossing.next;
        while(crssng != NULL) {
           if(crssng->z > 0.0) { /* Over crossing */
              fprintf(fp,"   %d %d   %d %d   %.4lf  %.4lf\n",
                           lnk->id, pnt->point_id,
                           crssng->partner->link_id,crssng->partner->point_id,
                           crssng->param,crssng->crossing->param);
             }
           crssng = crssng->next;
          }
        pnt = pnt->next;
       }
     lnk = lnk->next;
    }
  fprintf(fp," End \n\n");
  fclose(fp);
  return(0);
}

LinkSaveThreeD(status,name)
VOID *status; char *name;
/* returns 0 if successful */
{
  char strng[160];
  FILE *fp;
  LinkList *lnk;
  LinkPointList *pnt;
  LinkCrossingList *crssng;
  int num_links,num_points;

  LinkStatus *gnrc;
  gnrc = (LinkStatus *) status;

  fp = fopen(name,"w");
  if(fp == NULL) {
    sprintf(strng,"Cannot open file %s\n",name);
    LinkPrintMessage(gnrc,strng);
    return(-1);
   }
  fprintf(fp,"LINK\n");
  /* Count Number of links */
  num_links = 0;
  lnk = gnrc->link.next;
  while(lnk != NULL){
     if(lnk->point.next != NULL) { /* Print only nonempty links */
        num_links++;
       }
     lnk = lnk->next;
    }
   fprintf(fp,"%d\n",num_links);

  /* Count and print number of points for each strand */
  lnk = gnrc->link.next;
  while(lnk != NULL){
     if((pnt = lnk->point.next) != NULL) {  /* Non-empty links only */
        num_points=0;
        while(pnt != NULL) {
           num_points++;
           crssng = pnt->crossing.next;
           while(crssng != NULL) {
              num_points++;
              crssng = crssng->next;
             }
           pnt = pnt->next;
          }
        fprintf(fp,"%d\n",num_points);
       }
     lnk = lnk->next;
    }

  /* Print out starnd data */
  lnk = gnrc->link.next;
  while(lnk != NULL){
     if(lnk->point.next != NULL) { /* Only non-empty strands */
        LinkPrintStrand3D(gnrc,fp,lnk);
        fprintf(fp,"\n");
       }
     lnk = lnk->next;
    }
  fclose(fp);
  return(0);
}

LinkSavePS(status,name)
VOID *status; char *name;
/* returns 0 if successful */
{
  char strng[160];
  FILE *fp;
  LinkList *lnk;

  LinkStatus *gnrc;
  gnrc = (LinkStatus *) status;

  fp = fopen(name,"w");
  if(fp == NULL) {
    sprintf(strng,"Cannot open file %s\n",name);
    LinkPrintMessage(gnrc,strng);
    return(-1);
   }
  /* Print PS header */

  fprintf(fp,"%%!PS-Adobe-1.0\n");
/*
  fprintf(fp,"%%%%BoundingBox: %d %d %d %d\n",dcxmin,dcymin,dcxmax,dcymax);
*/

  fprintf(fp,"%%%%Pages: 1\n");
  fprintf(fp,"%%%%EndComments\n\n");


  /* 2.835 = Postscript units per mm */
  fprintf(fp,"%lf %lf scale\n",2.835,2.835);

  fprintf(fp,"0 setlinewidth\n");
  fprintf(fp,"1 setlinecap\n");

  fprintf(fp,"/vec { moveto lineto stroke } def\n");
  fprintf(fp,"%%%%Endprolog\n\n");
  fprintf(fp,"%%%%Page: 1\n\n");

  lnk = gnrc->link.next;
  while(lnk != NULL){
     LinkPrintStrandPS(gnrc,fp,lnk);
     lnk = lnk->next;
    }

  fprintf(fp,"\nshowpage\n");
  fprintf(fp,"%%%%Trailer\n");

  fclose(fp);
  return(0);
}

LinkGetFile(status,name)
VOID *status; char *name;
/* returns 0 if successful */
{
  char strng[40];
  int done,ch,num_links,num_crssng;
  FILE *fp;
  LinkList link,*lnk,*tmp_lnk;
  LinkPointList *pnt;
  int i,lnk_id,pnt_id;
  LinkStatus *gnrc;

  gnrc = (LinkStatus *) status;

  if((fp = fopen(name,"r")) == NULL) {
     sprintf(strng,"Could not open %s.",name);
     LinkPrintMessage(gnrc,strng);
     return(-1);
    }

  lnk = &link;
  lnk->next = NULL;
  num_links = 0;

  while(fscanf(fp,"%s",strng) == 1) {
     if(strcmp(strng,"Strand") == 0) {
        lnk->next = (LinkList *) malloc(sizeof(LinkList));
        lnk = lnk->next; lnk->next = NULL;
        lnk->point.next = NULL;
        lnk->num = 0; lnk->visible = LINK_YES;
        fscanf(fp,"%d",&(lnk->id));
        num_links++;
        if(LinkReadStrand(gnrc,fp,lnk) != 0) {
           sprintf(strng,"Error reading %s.",name);
           LinkPrintMessage(gnrc,strng);
           fclose(fp);
           return(-1);
          }
        continue;
       }
     if(strng[0] == '#') { /* Read till end of line */
        ch = 'a';
        while(ch != '\n' && ch != '\r') {
           ch = fgetc(fp);
           if(ch == EOF) {
              LinkPrintMessage(gnrc,"Error reading link file comment.");
              fclose(fp);
              return(-1);
             }
          }
       }
     if(strcmp(strng,"Crossings") == 0) {
        int up_lnk_id, dwn_lnk_id, up_pnt_id, dwn_pnt_id;
        LinkList *up_lnk,*dwn_lnk,**lnk_tbl;
        LinkPointList point,*up_pnt,*dwn_pnt;
        LinkCrossingList crossing;
        double up_param,dwn_param;
        double x0,y0,x1,y1;

        fscanf(fp,"%d",&num_crssng);

        /* make table of lnk pointers by id */
        if(num_links < 1) continue;
        lnk_tbl = (LinkList **) malloc(num_links*sizeof(LinkList *));
        tmp_lnk = link.next;
        while(tmp_lnk != NULL) {
           lnk_tbl[tmp_lnk->id] = tmp_lnk; 
           tmp_lnk = tmp_lnk->next;
          }

        /* Read crossings */
        for(i=0;i<num_crssng;++i) {
           fscanf(fp,"%d %d %d %d %lf %lf\n",&up_lnk_id,&up_pnt_id,
                                       &dwn_lnk_id,&dwn_pnt_id,
                                       &up_param,&dwn_param);
           up_lnk = lnk_tbl[up_lnk_id];
           dwn_lnk = lnk_tbl[dwn_lnk_id];

        /* find points corresponding to point id's */
        /* NOTE: point id's assumed correct from ReadStrand */
           up_pnt = up_lnk->point.next;
           while(up_pnt != NULL && up_pnt->point_id !=  up_pnt_id)
               up_pnt = up_pnt->next;
           dwn_pnt = dwn_lnk->point.next;
           while(dwn_pnt != NULL && dwn_pnt->point_id !=  dwn_pnt_id)
               dwn_pnt = dwn_pnt->next;

           if(up_pnt == NULL || dwn_pnt == NULL) {
              LinkPrintMessage(gnrc,"Invalid point id in crossing.");
              fclose(fp);
              return(-1);
             }

           x0 = up_pnt->x; y0 = up_pnt->y;
           if(up_pnt->next != NULL) 
              { x1 = up_pnt->next->x; y1 = up_pnt->next->y;}
           else if(up_lnk->closed) 
                   {x1=up_lnk->point.next->x; y1=up_lnk->point.next->y;}
           point.x = crossing.x = (1.0-up_param)*x0 + up_param*x1;
           point.y = crossing.y = (1.0-up_param)*y0 + up_param*y1;
           LinkComputePointDeviceCoords(gnrc,&point);
           crossing.dcx = point.dcx; crossing.dcy = point.dcy;

           LinkInsertCrossing(gnrc,up_lnk,up_pnt,dwn_lnk,dwn_pnt,
                                &crossing,up_param,dwn_param);
          }
        free(lnk_tbl);
        continue;
       }
    }

  
  /* Compute crossings between new and old links */
  lnk = link.next;
  while(lnk != NULL) {
     pnt = lnk->point.next;
     while(pnt != NULL) {
        LinkComputeEdgeCrossings(gnrc,lnk,pnt);
        pnt = pnt->next;
       }
     lnk = lnk->next;
    }

  /* Find last link of existing links */
  /* Join the new links with the old */
  lnk = &(gnrc->link);
  while(lnk->next != NULL) lnk = lnk->next;
  lnk->next = link.next;

  return(0);
}

LinkCenterView(status)
VOID *status; 
{
  LinkStatus *gnrc;
  LinkList *lnk;
  LinkPointList *pnt;
  int dcxmin,dcxmax,dcymin,dcymax;
  int dx,dy;
  double xfactor,yfactor;

  gnrc = (LinkStatus *) status;

  /* Compute dc bounding box */
  lnk = gnrc->link.next;
  /* find first lnk with non empty point list */
  while(lnk != NULL && lnk->point.next == NULL) lnk = lnk->next;
  if(lnk == NULL) return;

  pnt = lnk->point.next;
  dcxmin = pnt->dcx - 1;  dcxmax = pnt->dcx + 1;
  dcymin = pnt->dcy - 1;  dcymax = pnt->dcy + 1;
  while(lnk != NULL) {
     if(!lnk->visible) { lnk = lnk->next; continue;}
     pnt = lnk->point.next;
     while(pnt != NULL) {
         if(pnt->dcx < dcxmin) dcxmin = pnt->dcx;
         else if(pnt->dcx > dcxmax) dcxmax = pnt->dcx;
         if(pnt->dcy < dcymin) dcymin = pnt->dcy;
         else if(pnt->dcy > dcymax) dcymax = pnt->dcy;
         pnt = pnt->next;
        }
     lnk = lnk->next;
    }

  /* Put center of bounding box in center of screen */

  dx = gnrc->width/2  - (dcxmax + dcxmin)/2;
  dy = gnrc->height/2 - (dcymax + dcymin)/2;
  gnrc->origin.dcx += dx; gnrc->origin.dcy += dy;

  /* Adjust scale so bbox takes up at most 1/2 screen in x or y direction */
  /* Do not change aspect ratio */

  xfactor = 0.5 * (double) (gnrc->width) / (double) (dcxmax-dcxmin);
  yfactor = 0.5 * (double) (gnrc->height) / (double) (dcymax-dcymin);
  if(xfactor < yfactor) {
     gnrc->xscale *= xfactor; gnrc->yscale *= xfactor;
    }
  else {
     gnrc->xscale *= yfactor; gnrc->yscale *= yfactor;
    }
  LinkComputeDeviceCoords(gnrc);

  XClearWindow(dpy,gnrc->TopWindow);
  ReDrawLinkTopWindow(gnrc);
}


