/* The main module for link */

#include <stdio.h>
#include <X11/Xlib.h>
#include "link_types.h"

Display *dpy;
double xppmm,yppmm;  /* x and y pixels per millimeter */
double WidthMM,HeightMM;

LinkStatus link_status;
LinkData link_data;

main(argc,argv)

int argc;
char *argv[];

{
  Window top;
  XWindowAttributes xwa;
  XEvent event;

  /* Open up the connection to the X Server */

  if((dpy = XOpenDisplay(NULL)) == NULL) {
    fprintf(stderr,"Could not open server.\n");
    exit(1);
   }

  /* Get some basic information */
  WidthMM = (double) DisplayWidthMM(dpy,DefaultScreen(dpy));
  HeightMM = (double) DisplayHeightMM(dpy,DefaultScreen(dpy));
  xppmm = (double) DisplayWidth(dpy,DefaultScreen(dpy))/WidthMM;
  yppmm = (double) DisplayHeight(dpy,DefaultScreen(dpy))/HeightMM;

  /* initialize client */
  LinkSetUp(&link_data);

  while(1){

     XNextEvent(dpy,&event);
     top = event.xany.window;
     if(top == link_status.TopWindow ||
          top == link_status.MessageWindow ||
          top == link_status.TitleWindow) {
        LinkEvent(&link_status,&event);
        continue;
       }
    }
}

LinkSetUp(data)

LinkData *data;

{
  data->root = DefaultRootWindow(dpy);
  data->x =  LINK_X_OFFSET * WidthMM;
  data->y = LINK_Y_OFFSET * HeightMM;
  data->width = LINK_X_FRACTION * WidthMM;
  data->height = LINK_Y_FRACTION * HeightMM;
  data->border = LINK_BORDER;

  data->title_present = LINK_YES;
  data->message_present = LINK_YES;
  data->urgent_present = LINK_YES;

  data->xruler = LINK_NO;  /* Show ruler */
  data->yruler = LINK_NO;
  data->xscale = 1.0;
  data->yscale = 1.0;
  strcpy(data->data_font,"6x10");

  strcpy(data->title,"Link Title");
  strcpy(data->message,"Link Message");
  strcpy(data->font,"9x15");

  data->gray = 0.7;
}


