#include <stdio.h>
#include <X11/Xlib.h>
#include "link_types.h"
#include "link_global.h"


Window LinkInitialize(gnrc,data)

LinkStatus *gnrc;
LinkData *data;

{

  XSetWindowAttributes xswa;
  XWindowAttributes xwa;
  Window root,top;
  XGCValues xgcv;
  int x,y,width,height;
  Pixmap pxmp;
  XColor xcolor;
  int gray_value,depth;
  char mask,gray_bits[8];

  root = data->root;
  depth = DisplayPlanes(dpy,DefaultScreen(dpy));
  XGetWindowAttributes(dpy,root,&xwa);

  gnrc->color_ok = 0;
  if(depth > 4) {  /* Allocate color cell for background */
     gnrc->color_ok = 1;
     xcolor.red = xcolor.green = xcolor.blue = 
           (unsigned short) (65535.0 * data->gray);
     xcolor.flags = DoRed | DoGreen | DoBlue;
     if(XAllocColor(dpy,xwa.colormap,&xcolor) == 0) {
        gnrc->color_ok = 0;
        fprintf(stderr,"Display does not support grey background.\n");
       }
     else {
        xswa.background_pixel = xcolor.pixel;
       }
    }

  if(gnrc->color_ok == 0) {
     xswa.background_pixel = WhitePixel(dpy,DefaultScreen(dpy)); 
    }

  x = (int) (data->x * xppmm);
  y = (int) (data->y * yppmm);
  width = (int) (data->width * xppmm);
  height = (int) (data->height * yppmm);

  xswa.border_pixel = BlackPixel(dpy,DefaultScreen(dpy));
  xswa.event_mask = (KeyPressMask|ButtonPressMask|ExposureMask|
                     ButtonReleaseMask|StructureNotifyMask);

  top = XCreateWindow(dpy,root,x,y,width,height,
                            data->border,CopyFromParent,
                            InputOutput,CopyFromParent,
                            (CWBackPixel|CWEventMask|CWBorderPixel),
                             &xswa);
                            
  gnrc->TopWindow = top;
  XMapWindow(dpy,top);

  /* Create GC and reverse GC for link */

  /* Load the font */

  if((gnrc->fontstruct = XLoadQueryFont(dpy,data->font)) == NULL) {
    fprintf(stderr,"Can't open font %s\n",data->font);
    exit(1);
   }

  gnrc->fth = gnrc->fontstruct->max_bounds.ascent +
                  gnrc->fontstruct->max_bounds.descent;

  /* Create the gc */

  xgcv.font = gnrc->fontstruct->fid;
  xgcv.foreground = BlackPixel(dpy,DefaultScreen(dpy));
  xgcv.background = WhitePixel(dpy,DefaultScreen(dpy));
  gnrc->gc = XCreateGC(dpy,gnrc->TopWindow,(GCFont|
                            GCForeground|GCBackground),&xgcv);

  /* Create the reverse gc */

  xgcv.foreground = WhitePixel(dpy,DefaultScreen(dpy));
  xgcv.background = BlackPixel(dpy,DefaultScreen(dpy));
  gnrc->reverse_gc = XCreateGC(dpy,gnrc->TopWindow,(GCFont|
                            GCForeground|GCBackground),&xgcv);

  if(data->urgent_present == LINK_YES) CreateLinkUrgentWindow(gnrc,data);
  else gnrc->UrgentWindow = (Window) 0;

  if(data->title_present == LINK_YES) CreateLinkTitleWindow(gnrc,data);
  else gnrc->TitleWindow = (Window) 0;

  if(data->message_present == LINK_YES) 
     CreateLinkMessageWindow(gnrc,data);
  else gnrc->MessageWindow = (Window) 0;

  /* Initialize data */
  gnrc->width = width; gnrc->height = height;

  gnrc->hash_space = LINK_HASH_SPACE * xppmm;
  gnrc->hash_height = LINK_HASH_HEIGHT * yppmm;

  gnrc->axes = LINK_SHOW;
  if(data->xruler == LINK_YES) gnrc->xruler = LINK_SHOW;
  else  gnrc->xruler = LINK_HIDE;
  if(data->yruler == LINK_YES) gnrc->yruler = LINK_SHOW;
  else gnrc->yruler = LINK_HIDE;
  gnrc->vertices = LINK_SHOW;
  gnrc->arrows = LINK_SHOW;

  gnrc->origin.x = data->width/2.0; gnrc->origin.y = data->height/2.0;
  gnrc->origin.dcx = width/2; gnrc->origin.dcy = height/2;

  gnrc->xscale = data->xscale;
  gnrc->yscale = data->yscale;

  gnrc->link.next = NULL;
  gnrc->num = 0;
  gnrc->choice[0] = LINK_NO_CHOICE;

  /* Create data GC */
  if((gnrc->data_fontstruct = XLoadQueryFont(dpy,data->data_font)) == NULL) {
    if((gnrc->data_fontstruct = XLoadQueryFont(dpy,"fixed")) == NULL) {
       fprintf(stderr,"Can't open font %s\n",data->data_font);
       exit(1);
      }
   }
  gnrc->data_fth = gnrc->data_fontstruct->max_bounds.ascent +
                  gnrc->data_fontstruct->max_bounds.descent;

  /* Create the gc */
  xgcv.font = gnrc->data_fontstruct->fid;
  xgcv.foreground = BlackPixel(dpy,DefaultScreen(dpy));
  xgcv.background = WhitePixel(dpy,DefaultScreen(dpy));
  xgcv.line_width = LINK_LINE_WIDTH;
  gnrc->data_gc = XCreateGC(dpy,gnrc->TopWindow,(GCFont|
                            GCForeground|GCBackground|GCLineWidth),&xgcv);

  xgcv.background = BlackPixel(dpy,DefaultScreen(dpy));
  xgcv.foreground = WhitePixel(dpy,DefaultScreen(dpy));
  gnrc->reverse_data_gc = XCreateGC(dpy,gnrc->TopWindow,(GCFont|
                            GCForeground|GCBackground|GCLineWidth),&xgcv);

  /* GC for xor'ing */
  xgcv.function = GXxor;
  xgcv.foreground = xswa.background_pixel^BlackPixel(dpy,DefaultScreen(dpy));
  xgcv.background = xswa.background_pixel; 

  gnrc->xor_gc = XCreateGC(dpy,gnrc->TopWindow,(GCForeground|
                             GCBackground|GCFunction),&xgcv);
  /* Create cursor for this window */
  XDefineCursor(dpy,top,XCreateFontCursor(dpy,LINK_CURSOR));
}


CreateLinkMessageWindow(gnrc,data)

LinkStatus *gnrc;
LinkData *data;

{
  XSetWindowAttributes xswa;
  XWindowAttributes xwa;
  int width,height,x_offset,y_offset;

  XGetWindowAttributes(dpy,gnrc->TopWindow,&xwa);

  height = gnrc->fth + 2*LINK_PAD;
  width = xwa.width;

  x_offset = 0;
  y_offset = xwa.height - height;


  xswa.background_pixel = BlackPixel(dpy,DefaultScreen(dpy));

  xswa.win_gravity = SouthWestGravity;
  xswa.event_mask = (ExposureMask|ButtonPressMask|ButtonReleaseMask|
                     KeyPressMask);

  gnrc->MessageWindow = XCreateWindow(dpy,gnrc->TopWindow,
                           x_offset,y_offset,width,height,
                           0,CopyFromParent,InputOutput,CopyFromParent,
                           (CWBackPixel|CWWinGravity|
                            CWEventMask),&xswa);

  LinkPrintMessage(gnrc,data->message);
  XMapWindow(dpy,gnrc->MessageWindow);

}


CreateLinkTitleWindow(gnrc,data)

LinkStatus *gnrc;
LinkData *data;

{
  XSetWindowAttributes xswa;
  XWindowAttributes xwa;

  XGetWindowAttributes(dpy,gnrc->TopWindow,&xwa);

  xswa.background_pixel = WhitePixel(dpy,DefaultScreen(dpy));;
  xswa.border_pixel = BlackPixel(dpy,DefaultScreen(dpy));
  xswa.event_mask = (ExposureMask|ButtonPressMask|
                     ButtonReleaseMask);

  gnrc->TitleWindow = XCreateWindow(dpy,gnrc->TopWindow,-1,-1,
                            xwa.width+1,gnrc->fth + 2*LINK_PAD+1,1,
                            CopyFromParent,InputOutput,CopyFromParent,
                            (CWBackPixel|CWBorderPixel|CWEventMask),&xswa);

  strcpy(gnrc->title,data->title);
  XMapWindow(dpy,gnrc->TitleWindow);


}


CreateLinkUrgentWindow(gnrc,data)

LinkStatus *gnrc;
LinkData *data;

{
  XSetWindowAttributes xswa;
  XWindowAttributes xwa;

  XGetWindowAttributes(dpy,gnrc->TopWindow,&xwa);

  xswa.background_pixel = WhitePixel(dpy,DefaultScreen(dpy));;
  xswa.border_pixel = BlackPixel(dpy,DefaultScreen(dpy));
  xswa.event_mask = (KeyPressMask|ExposureMask|ButtonPressMask|
                     ButtonReleaseMask);

  gnrc->UrgentWindow = XCreateWindow(dpy,gnrc->TopWindow,0,
                          xwa.height/2,xwa.width,gnrc->fth + 2*LINK_PAD,
                            5,CopyFromParent,InputOutput,CopyFromParent,
                            (CWBackPixel|CWBorderPixel|CWEventMask),&xswa);

}



