/*
Initialize all parameters for a given dynamical system to be installed
Parameters are assigned to the default values before this program is called.
-----------------------------------------------------------------------
This is a GENERIC subroutine. If you want, you can change
the name string "userds0" to a proper one globally in this program
but then you need to change the same strings in the header file defining
the current class of dynamical systems.
*/

/*
Example 1: map with periodic variable
*/
int userds0_init()
{
	extern int (*f_p)(),userds0_f(),(*func_p)(),userds0_func();
	extern int var_dim,func_dim,param_dim;
	extern int mapping_on,inverse_on,fderiv_on,enable_polar,enable_period;
	extern double *param,*param_min,*param_max,*func,*func_min,*func_max;
	extern double *var_i,*var_polar_i,*var_min,*var_max,*var_polar_min,*var_polar_max;
	extern double *period_len,pi;
	extern char *title_label,**var_label,**var_polar_label,**param_label,**func_label;

	/* title label */
	title_label = "Chandra Flow";

	/* mapping toggle: 1: map 0: vector field */
	mapping_on = 0;
	/* inverse toggle: vector field: always 1,
	   maps: 1=explicit inverse is defined, 0=otherwise  */     /*  mrm (2/6/90 )  */
	inverse_on = 1;
	/* jacobian toggle: 1=Jacobian is explicitly given, 0=otherwise */
	fderiv_on = 0;
	/* polar toggle: 1=enable polar coordinate feature, 0=otherwise */
	enable_polar = 0;
	/* period toggle: 1=enable periodicity of phase space, 0=otherwise */
	enable_period = 1;

	/* phase space dimension */
	var_dim = 3;
	/* parameter space dimension */
	param_dim = 1;
	/* function space dimension */
	func_dim = 2;

	(void) malloc_init();

	/*periodicity of phase space variables (DIM=var_dim)*/
	/* do not have to be defined if enable_period = 0 */
	period_len[0] =1;
	period_len[1] =1;
	period_len[2] =1;

	/* primary phase space variable label (DIM=var_dim)*/
	var_label[0] = "x";
	var_label[1] = "y";
	var_label[2] = "z";
	/* seconsary phase space variable label (DIM=param_dim)*/
	var_polar_label[0] = "~";
	var_polar_label[1] = "~";
	
	/* parameter variable label (DIM=param_dim)*/
	param_label[0] = "k";
	/* function variable label (DIM=func_dim)*/
	func_label[0] = "F1";
	func_label[1] = "F2";

	/* starting parameter values (DIM=param_dim)*/
	param[0] = 2;

	/* starting primary phase space variable values (DIM=param_dim)*/
	var_i[0] = 1.5;
	var_i[1] = 1.5;
	var_i[2] = 0.001;
	/* starting seconsary phase space variable values (DIM=param_dim)*/
	/* do not have to be defined if enable_polar = 0 */
	var_polar_i[0] = 0;
	var_polar_i[1] = 0;

	/* starting bounds of parameter window box */
	param_min[0]= 0; param_max[0]= 10;

	/* starting bounds of primary phase space window box */
	var_min[0]= 0; var_max[0]= 1;
	var_min[1]= 0; var_max[1]= 1;
	var_min[2]= 0; var_max[2]= 1;

	/* starting bounds of secondary phase space window box */
	/* do not have to be defined if enable_polar = 0 */
	var_polar_min[0]= -5; var_polar_max[0]= 5;
	var_polar_min[1]= -5; var_polar_max[1]= 5;

	/* dynamical system and function pointer assignments */
	f_p = userds0_f;
	func_p = userds0_func;
}
/*
first user dynamical system
*/
	
int userds0_f(f,index,x,p,t,dim)
int index,dim;
double f[],x[],p[],t;
{
	double sx,cx,sy,cy,sz,cz,sin(),cos();
	extern double twopi;

	sx = sin(twopi * x[0]);
	sy = sin(twopi * x[1]);
	sz = sin(twopi * x[2]);
	cx = cos(twopi * x[0]);
	cy = cos(twopi * x[1]);
	cz = cos(twopi * x[2]);
	f[0] = - (sx*cy + p[0]*p[0]*cx*sy)*cz;
	f[1] = - (cx * sy - p[0]*p[0] *sx * cy) * cz;
	f[2] = 2. * cx * cy * sz;
}
/*
first user function subroutine
*/

int userds0_func(f,x,p,t,dim)
double f[],x[],p[],t;
int dim;
{
	double sx,cx,sy,cy,sz,cz,sin(),cos();
	sx = sin(twopi * x[0]);
	sy = sin(twopi * x[1]);
	sz = sin(twopi * x[2]);
	f[0] = sx * sy * sz;
	f[1] = 0;
}
