/*
### create a tser window ###
*/

#include <suntool/sunview.h>
#include <suntool/panel.h>

void create_tser_windows()
{
	void tser_quit_proc(),tser_copy_proc(),tser_clear_proc();
	void tser_fft_proc(),tser_lyap_proc(),tser_dims_proc();
	void tser_algorithm_option_proc(),tser_data_option_proc();
	int i,ipanel_row=0,px,py;
	extern Frame frame,tser_frame;
	extern Panel tser_panel;
	extern Pixfont *boldfont;
	extern Panel_item tser_quit_item,tser_copy_item,tser_clear_item;
	extern Panel_item tser_fft_item,tser_lyap_item,tser_dims_item;
	extern Panel_item tser_data_option_item,tser_algorithm_option_item;
	extern short tser_panel_show;
	extern int panel_colormap_on;
	extern int tser_data_option,tser_algorithm_option;
	extern char string[];
	
	/* Turn on the flag */	
	if(tser_panel_show){
		window_set(tser_frame,WIN_SHOW,TRUE,0);	
		return;
	}
	else
		tser_panel_show = 1;

	px = (int) window_get(frame,WIN_X) + (int) window_get(frame,WIN_WIDTH)/2;
	py = (int) window_get(frame,WIN_Y) + (int) window_get(frame,WIN_HEIGHT) /2;
	/* Create tser frame */
	tser_frame = window_create(frame,FRAME,
		FRAME_NO_CONFIRM,       TRUE,
		FRAME_LABEL,    "time series",
		FRAME_SHOW_LABEL,       TRUE,
		WIN_SHOW,       TRUE,
		WIN_X,  px,
		WIN_Y,  py,
		WIN_FONT, boldfont,
		0);
	if(tser_frame == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		tser_panel_show = 0;
		return;
	}
	/* Create Panel */
	tser_panel = window_create(tser_frame, PANEL,
		WIN_X, 0,
		WIN_Y, 0,
		WIN_FONT, boldfont,
		0);
	if(tser_panel == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		(void) destroy_tser_windows();
		return;
	}
	/* Create panel items */
	tser_quit_item= panel_create_item(tser_panel, PANEL_BUTTON,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_LABEL_IMAGE, panel_button_image(tser_panel, "Quit", 5, boldfont),
		PANEL_NOTIFY_PROC, tser_quit_proc,
		0);
	tser_copy_item= panel_create_item(tser_panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE, panel_button_image(tser_panel, "Copy", 5, boldfont),
		PANEL_NOTIFY_PROC, tser_copy_proc,
		0);
	tser_clear_item= panel_create_item(tser_panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE, panel_button_image(tser_panel, "Clear", 5, boldfont),
		PANEL_NOTIFY_PROC, tser_clear_proc,
		0);
	tser_fft_item= panel_create_item(tser_panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE, panel_button_image(tser_panel, "Four", 5, boldfont),
		PANEL_NOTIFY_PROC, tser_fft_proc,
		0);
	tser_lyap_item= panel_create_item(tser_panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE, panel_button_image(tser_panel, "Lyap", 5, boldfont),
		PANEL_NOTIFY_PROC, tser_lyap_proc,
		0);
	tser_dims_item= panel_create_item(tser_panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE, panel_button_image(tser_panel, "Dims", 5, boldfont),
		PANEL_NOTIFY_PROC, tser_dims_proc,
		0);
	tser_data_option_item= panel_create_item(tser_panel, PANEL_CYCLE,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		PANEL_LABEL_STRING, "Input Data: ",
		PANEL_CHOICE_STRINGS,
			"From current orbit data",
			"From copied time series",
			0,
		PANEL_VALUE, tser_data_option,
		PANEL_NOTIFY_PROC, tser_data_option_proc,
		0);
	tser_algorithm_option_item= panel_create_item(tser_panel, PANEL_CYCLE,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		PANEL_LABEL_STRING, "Algorithm: ",
		PANEL_CHOICE_STRINGS,
			"Sum of all components",
			"Sum of squares of all components",
			"A Component",
			0,
		PANEL_VALUE, tser_algorithm_option,
		PANEL_NOTIFY_PROC, tser_algorithm_option_proc,
		0);

	window_fit(tser_panel);
	window_fit(tser_frame);

	if(panel_colormap_on)
		init_panel_colormap((Pixwin *) window_get(tser_panel,WIN_PIXWIN),"tser_panel_cms");
}
