/*
### display system messages in different ways ###

Input: mode: 0: non-error message on the canvas
       mode: 1: error message with a bell if it is on
       mode: 2: flush message to the parent window
       mode: 3: message with a popup window
*/

#include "../include/x11r2_kaos_def.h"
#include <suntool/sunview.h>

system_mess_proc(mode,s)
char *s;
int mode;
{
	int i,color,color2;
	static char s_p[80],s_pp[80],s_ppp[80];
	extern Pixwin *pw;
	extern Pixfont *boldfont;
	extern int batch_on,bell_on,slide_mode,invert_background;
	extern int l_margin,y_message,y_line_height;
	extern Frame frame;
	/* length of each line is suggested to be less than 60
	maximum of two lines at this time */
	
	if(slide_mode)
		return;
	if(batch_on){
		printf("%s\n",s);
		return;
	}
	if(mode==0 || mode==1)
		clear_region(4);
	if(invert_background==0){
		color = Blue;
		color2 = DarkGreen;
	}
	else {
		color = SkyBlue;
		color2 = Yellow;
	}
	if(mode==0 || mode==1 ){
		if(s_ppp != NULL)
			pw_text(pw,l_margin,y_message+y_line_height,PIX_SRC ^ PIX_DST | PIX_COLOR(color),boldfont, s_ppp);
		if(s_pp != NULL)
			pw_text(pw,l_margin,y_message+2*y_line_height,PIX_SRC ^ PIX_DST | PIX_COLOR(color),boldfont, s_pp);
		if(s_p != NULL)
			pw_text(pw,l_margin,y_message+3*y_line_height,PIX_SRC ^ PIX_DST | PIX_COLOR(color),boldfont, s_p);
		if(s != NULL)
			pw_text(pw,l_margin,y_message+4*y_line_height+5,PIX_SRC ^ PIX_DST | PIX_COLOR(color2),boldfont, s);
		if(strcmp(s,"Done!") == 0){
			sprintf(s_ppp,"%s %s",s_pp,s);
			sprintf(s_pp,"%s %s",s_p,s);
			sprintf(s_p,"");
		}
		else {
			sprintf(s_ppp,"%s",s_pp);
			sprintf(s_pp,"%s",s_p);
			sprintf(s_p,"%s",s);
		}
		if(mode == 1 && bell_on == 1)
			window_bell(frame);
	}
	if(mode==-1){
		error_mess_proc(s,"Confirm","");
	}
}
