/*
### reset main panels and parameters after loading data or selecting a model ###
*/

reset_main_panels()
{
	extern int enable_polar,func_on,model,polar_coord,polar_section,draw_all;
	extern int func_on_old,model_old,polar_coord_old,polar_section_old,enable_polar_old,draw_all_old;
	extern short main_panel_show,window_size_panel_show,options_panel_show,section_panel_show,save_load_panel_show,system_info_panel_show;

	/* criteria for recrating the main panel and labels */
	if (model_old != model || enable_polar!=enable_polar_old
		|| polar_coord_old!=polar_coord ){
		if(main_panel_show){
			(void) destroy_main_panel();
			(void) create_main_panel();
		}
	}

	/* criteria for recreating section panel*/
	if (model_old != model || enable_polar!=enable_polar_old
		|| polar_section != polar_section_old || func_on_old != func_on) {
			if (section_panel_show) {
				(void) destroy_section_panel();
				(void) create_section_panel();
			}
	}

	/* criteria for recreating system info panel*/
	if (model_old != model || func_on != func_on_old || draw_all != draw_all_old ) {
		if (system_info_panel_show) {
			(void) destroy_system_info_panel();
			(void) create_system_info_panel();
		}
	}

	/* cycle items for the same model are not refreshed at the moment
	unless the entire panel is recreated for other reasons */
	if (window_size_panel_show){
		(void) destroy_window_size_panel();
		(void) create_window_size_panel();
	}
	if (options_panel_show){
		(void) destroy_options_panel();
		(void) create_options_panel();
	}
	if(model_old != model){
		if (save_load_panel_show){
			(void) destroy_save_load_panel();
			(void) create_save_load_panel();
		}
	}
}
