/*
### book-keeping initializations for computing orbits ###
*/

#include <stdio.h>
#include <math.h>

compute_orbit(forward_toggle)
int forward_toggle;
{
	int i,region_index_old,pix_type_old;
	extern int var_dim,func_dim,param_dim;
	extern int var_cur_index[],inverse_on,mapping_on;
	extern int pix_type,region_index,lock_count,continue_toggle,enable_period;
	extern int i_step,i_stop,segment_count1,n_stored_data1,n_stored_data0,n_displayed_data1,n_displayed_data0,var_cur_index[],section_count;
	extern int int_driver;
	extern int var_dim,param_dim,polar_coord,var_colormap_size,colormap_option,show_error_mess,n_stored_data_segment1[],polar_section,section_index;
	extern double pi,average_return_time,time,time_step,colorcode_min,colorcode_max,section_constant;
	extern double *t_v,*win_var_i,*win_var_f,*all_min,*all_max,*param,*func_i,*func_f;
	extern char string[],string2[],**all_label;

	region_index_old = region_index;
	pix_type_old = pix_type;
	lock_count = 0;
	region_index = 1;
	pix_type = 0;

	if ((colormap_option == 1 || colormap_option == 2) && colorcode_min > colorcode_max) {
		system_mess_proc(1,"Error: minimum of colorcode scale larger than maximum!");
		return;
	}
	if (all_min[var_cur_index[0]] > all_max[var_cur_index[0]]) {
		system_mess_proc(1,"Error: minimum of window variable x larger than maximum!");
		return;
	}
	/*
	if (all_min[var_cur_index[1]] > all_max[var_cur_index[1]]) {
		system_mess_proc(1,"Error: minimum of window variable y larger than maximum!");
		return;
	}
	/*
	if (time_step <= 0) {
		system_mess_proc(1,"Error: size of time step less than or equal to 0!");
		return;
	}
	*/
	if (i_step < 1) {
		system_mess_proc(1, "Error: step between data plotting (i_step) less than 1!");
		return;
	}
	if(polar_section && section_index == 2 && (fabs(section_constant - pi) < 1.e-4 
		|| fabs(section_constant + pi) < 1.e-4)){
		system_mess_proc(1,"section too close to a discontinuity in angle variable. Use Euclidean coords.");
	}

	/* initialize the colormap for orbit computation */
	(void) orbit_colormap_init();

	if (!continue_toggle) {
		if(int_driver==0)
			time = 0;
		from_window_variables(t_v,win_var_i,polar_coord);
		(void) get_func(func_i,t_v,param,time,var_dim);
		all_refresh();
	}

	lock();

	/* two routines for map and ode, respectively */
	if(mapping_on){
		if (forward_toggle == 1){
			system_mess_proc(0,"Iterating maps forwards...");
			i_stop = (int) map_forward();
		}
		else {
			if(inverse_on){
				system_mess_proc(0,"Iterating maps backwards explicitly using an inverse...");
				i_stop = (int) map_forward();
			}
			else {
				system_mess_proc(0,"Iterating maps backwards implicitly...");
				i_stop = (int) map_implicit_backward();
			}
		}
	}
	else {
		if(int_driver == 0 || int_driver == 1){ 
			if (forward_toggle == 1){
				system_mess_proc(0,"Integrating forwards...");
				i_stop = (int) ode_forward();
			}
			else {
				system_mess_proc(0,"Integrating backwards...");
				time_step = -time_step;
				i_stop = (int) ode_forward();
				time_step = -time_step;
			}
		}
		else if(int_driver == 2){
			if (forward_toggle == 1){
				system_mess_proc(0,"Integrating forwards with error control...");
				i_stop = (int) ode_qc_forward();
			}
			else {
				system_mess_proc(0,"Integrating backwards with error control...");
				time_step = -time_step;
				i_stop = (int) ode_qc_forward();
				time_step = -time_step;
			}
		}
	}
	unlock();

	n_stored_data_segment1[segment_count1] = n_stored_data1;

	if(enable_period==1)
		make_periodic(t_v,win_var_f,var_dim);

	printf("SegCnt1=%d,NData=%d\n",segment_count1,n_stored_data_segment1[segment_count1]);
	if(var_dim <= 8) {
		sprintf(string,"Xf:");
		for(i=0;i<var_dim;i++){
			sprintf(string2,"%s %s=%g ",string,all_label[i],win_var_f[i]);
			strcpy(string,string2);
			if(i % 4 == 3 || i == var_dim-1 ){
				system_mess_proc(0,string);
				sprintf(string,"");
			}
		}
	}
	else {
		system_mess_proc(0,"Final X not displayed for dim>%d. look into the parent window.");
	}	

	printf("Xf: ");
	for(i=0;i<var_dim;i++){
		printf("%s=%22.14g ",all_label[i],win_var_f[i]);
		if (i == var_dim-1)
			printf("\n");
		else if(i % 2 == 1 )
			printf("\n    ");
	}

	system_mess_proc(0,"Done!"); 

	from_window_variables(t_v,win_var_f,polar_coord);
	(void) get_func(func_f,t_v,param,time,var_dim);
	all_refresh();
	if (section_count == 0)
		average_return_time = -999;
	else
		average_return_time = time_step * i_stop / (double) section_count;
	region_index = region_index_old;
	pix_type= pix_type_old;
}
