
int threeosc_init()
{
	title_label = "Diss Period. Forced Oscillator";

	mapping_on = 0;
	inverse_on = 1;
	fderiv_on = 0;
	enable_polar = 0;
	enable_period = 1;
	period_len[1] = 1.;
	period_len[3] = 1.;

	var_dim = 4;
	param_dim = 5;
	func_dim = 2;

	(void) malloc_init();

	var_label[0] = "xdot";
	var_label[1] = "x";
	var_label[2] = "ydot";
	var_label[3] = "y";
	param_label[0] = "beta1";
	param_label[1] = "beta2";
	param_label[2] = "alpha";
	param_label[3] = "dcamp";
	param_label[4] = "acamp";
	func_label[0] = "t";
	func_label[1] = "Undefined";

	param[0] = 1;
	param[1] = 1;
	param[2] = 0.3;
	param[3] = 1;
	param[4] = 1;
	var_i[0] = 0;
	var_i[1] = 0;
	var_i[2] = 0;
	var_i[3] = 0;

	param_min[0]= -5; param_max[0]= 5;
	param_min[1]= -5; param_max[1]= 5;
	param_min[2]= -5; param_max[2]= 5;
	param_min[3]= -5; param_max[3]= 5;
	param_min[4]= -5; param_max[4]= 5;
	var_min[0]= -5; var_max[0]= 5;
	var_min[1]= 0; var_max[1]= 1;
	var_min[2]= -5; var_max[2]= 5;
	var_min[3]= 0; var_max[3]= 1;
	func_min[0]= -5; func_max[0]= 5;

	f_p = threeosc_f;
	func_p = threeosc_func;
}
int threeosc_f(f,index,x,p,t,dim)
int index,dim;
double f[],x[],p[],t;
{
	double sum,sinx0,sinx2,cost;

	sinx0 = sin(twopi * x[0]);
	sinx2 = sin(twopi * x[2]);
	cost = cos(twopi * t);
	sum = x[0] + sinx0 + x[2] + sinx2;
	f[0] = x[1];
	f[1] = (-x[1] - sinx0 + p[2] * sum - p[3] - p[4] * cost) / p[0];
	f[2] = x[3];
	f[3] = (-x[3] - sinx2 + p[2] * sum - p[3] - p[4] * cost) / p[1];
}
int threeosc_func(f,x,p,t,dim)
double f[],x[],p[],t;
int dim;
{
	f[0] = t;
}
