/* Model dependent definitions */
#define MODEL_DIM 14 /* number of models installed */
#define MODEL_LABELS  \
"User Dynamical System 0",\
"User Dynamical System 1",\
"User Dynamical System 2",\
"D4 Nilpotent Ham --",\
"D4 Nilpotent Ham ++",\
"D4 Dissipative -- +",\
"Lorenz system",\
"Nonlinear Mathieu Eq",\
"Diss Per. Forced. Osc. II",\
"Henon Map",\
"Kim-Ostlund Torus Map",\
"Dissipative Standard Map",\
"Siegel Map",\
"Marty's D3 Map"

/* customizable definitions */
#define VAR_DIM_MAX 30 /* maximal dimension of variables */
#define PARAM_DIM_MAX 30	/* maximal dimension of parameters */
#define FUNC_DIM_MAX 10 /* maximal dimension of function definitions */
#define FULL_DIM_MAX VAR_DIM_MAX+FUNC_DIM_MAX
#define ALL_DIM_MAX FULL_DIM_MAX+PARAM_DIM_MAX
#define AUX_MAX 3	/* number of auxiliary display windows */

/* variable labels to be used for cycle_item: # of elements = VAR_DIM_MAX */
#define VAR_LABELS \
var_label[0],var_label[1],var_label[2],\
var_label[3],var_label[4],var_label[5],\
var_label[6],var_label[7],var_label[8],\
var_label[9],var_label[10],var_label[11],\
var_label[12],var_label[13],var_label[14],\
var_label[15],var_label[16],var_label[17],\
var_label[18],var_label[19],var_label[20],\
var_label[21],var_label[22],var_label[23],\
var_label[24],var_label[25],var_label[26],\
var_label[27],var_label[28],var_label[29]
#define VAR_POLAR_LABELS \
var_polar_label[0],var_polar_label[1],var_polar_label[2],\
var_polar_label[3],var_polar_label[4],var_polar_label[5],\
var_polar_label[6],var_polar_label[7],var_polar_label[8],\
var_polar_label[9],var_polar_label[10],var_polar_label[11],\
var_polar_label[12],var_polar_label[13],var_polar_label[14],\
var_polar_label[15],var_polar_label[16],var_polar_label[17],\
var_polar_label[18],var_polar_label[19],var_polar_label[20],\
var_polar_label[21],var_polar_label[22],var_polar_label[23],\
var_polar_label[24],var_polar_label[25],var_polar_label[26],\
var_polar_label[27],var_polar_label[28],var_polar_label[29]
#define WIN_VAR_LABELS \
all_label[0],all_label[1],all_label[2],\
win_var_label[3],win_var_label[4],win_var_label[5],\
win_var_label[6],win_var_label[7],win_var_label[8],\
win_var_label[9],win_var_label[10],win_var_label[11],\
win_var_label[12],win_var_label[13],win_var_label[14],\
win_var_label[15],win_var_label[16],win_var_label[17],\
win_var_label[18],win_var_label[19],win_var_label[20],\
win_var_label[21],win_var_label[22],win_var_label[23],\
win_var_label[24],win_var_label[25],win_var_label[26],\
win_var_label[27],win_var_label[28],win_var_label[29],\
win_var_label[30],win_var_label[31],win_var_label[32],\
win_var_label[33],win_var_label[34],win_var_label[35],\
win_var_label[36],win_var_label[37],win_var_label[38],\
win_var_label[39]

/* parameter labels to be used for cycle_item: # of elements = PARAM_DIM_MAX*/
#define PARAM_LABELS \
param_label[0],param_label[1], param_label[2],\
param_label[3],param_label[4], param_label[5],\
param_label[6],param_label[7], param_label[8],\
param_label[9],param_label[10], param_label[11],\
param_label[12],param_label[13], param_label[14],\
param_label[15],param_label[16], param_label[17],\
param_label[18],param_label[19]

#define ALL_LABELS\
all_label[0],all_label[1],all_label[2],\
all_label[3],all_label[4],all_label[5],\
all_label[6],all_label[7],all_label[8],\
all_label[9],all_label[10],all_label[11],\
all_label[12],all_label[13],all_label[14],\
all_label[15],all_label[16],all_label[17],\
all_label[18],all_label[19],all_label[20],\
all_label[21],all_label[22],all_label[23],\
all_label[24],all_label[25],all_label[26],\
all_label[27],all_label[28],all_label[29],\
all_label[30],all_label[31],all_label[32],\
all_label[33],all_label[34],all_label[35],\
all_label[36],all_label[37],all_label[38],\
all_label[39],all_label[40],all_label[41],\
all_label[42],all_label[43],all_label[44],\
all_label[45],all_label[46],all_label[47],\
all_label[48],all_label[49],all_label[50],\
all_label[51],all_label[52],all_label[53],\
all_label[54],all_label[55],all_label[56],\
all_label[57],all_label[58],all_label[59]
