/*
*****************************************************************************

		Kaos Sunview global variables

	Swan Kim and John Guckenheimer, POSTECH & Cornell U, 11/1/89

*****************************************************************************
	Names of most items are mnemonic and are obviously connected to the
	global variables when the suffix "_item" is deleted, so that
	the description of most items is ommitted.
*****************************************************************************
*/

/*-----------------------------------------------------------------------------
	Miscelleneous Sunview objects 
-----------------------------------------------------------------------------*/
Pixfont *boldfont;	/* Bold font 12 point */
Pixfont *boldfont24;	/* Bold font 24 point */
Pixfont *courier10;	/* Courier font 10 point */
Rect *rectp;		/* pixrect rectangle */
Event *event;		/* Sunview Event */

/*-----------------------------------------------------------------------------
	Sunview objects for the base phase space window 
-----------------------------------------------------------------------------*/
Frame frame;		/* base frame (phase space frame) */
Cursor cursor;		/* phase space cursor */
Canvas canvas;		/* phase space canvas */
Pixwin *pw;		/* phase space pixwin */

/*-----------------------------------------------------------------------------
	Sunview objects for the parameter space window 
-----------------------------------------------------------------------------*/
Frame param_frame;	/* parameter space frame */
Canvas param_canvas;	/* parameter space canvas */
Cursor param_cursor;	/* parameter space cursor */
Pixwin *param_pw;	/* parameter space pixwin */

/*-----------------------------------------------------------------------------
	Sunview objects for the main panel
-----------------------------------------------------------------------------*/
Frame main_frame; 	/* main panel frame */
Panel panel;		/* main panel panel */
Panel_item quit_item,open_item,reset_item,print_item;	/* Quit, Open, Reset, Print buttons */
Panel_item user_item,forward_item,backward_item;	/* User, Forw, Back buttons */
Panel_item continue_item,batch_item;			/* Cont, Batch buttons */
Panel_item top_item,add_point_item,remove_point_item;	/* Top, Add point, Remove point buttons */
Panel_item i_start_item,i_max_item,i_step_item;		/* i_start, i_max, i_step text items */
Panel_item *param_item,*var_i_item;			/* Parameters, initial variables text item */
Panel_item time_step_item;				/* Time step text item */

/*-----------------------------------------------------------------------------
	Sunview Objects for the system info window
-----------------------------------------------------------------------------*/
Frame system_info_frame;	/* frame */
Panel system_info_panel;	/* panel */
Panel_item system_info_panel_quit_item;	/* Quit button */
Panel_item n_displayed_data1_item,n_displayed_data0_item,average_return_time_item;	/* text items */
Panel_item *func_i_item,*func_f_item;	/* text items */

/*-----------------------------------------------------------------------------
	Sunview Objects for the option window
-----------------------------------------------------------------------------*/
Frame options_frame;	/* frame */
Panel options_panel;	/* panel */
Panel_item options_panel_quit_item;	/* buttons */
Panel_item model_item,transient_item,dot_size_item; /* cycles */
Panel_item draw_all_item,polar_coord_item; /* cycles */
Panel_item invert_background_item,colormap_option_item,colorcode_depth_index_item;	/* cycles */
Panel_item symbol_type_item,symbol_size_item;	/* cycles */
Panel_item colorcode_min_item,colorcode_max_item,cur_color_item;	/* text items */

/*-----------------------------------------------------------------------------
	Sunview Objects for the section window
-----------------------------------------------------------------------------*/
Frame section_frame;
Panel section_panel;
Panel_item section_panel_quit_item;
Panel_item polar_section_item,section_index_item,linear_interpolation_item,n_poincare_item,section_constant_item;

/*-----------------------------------------------------------------------------
	Sunview Objects for the projection (window size) window
-----------------------------------------------------------------------------*/
Frame window_size_frame;
Panel window_size_panel;
Panel_item window_size_panel_quit_item;
Panel_item clear_last_item,redisplay_item,n_stored_data1_item,n_stored_data0_item;
Panel_item proj_var_item[2],proj_param_item[2];
Panel_item *all_min_item,*all_max_item;

/*-----------------------------------------------------------------------------
	Sunview Objects for the save-load window
-----------------------------------------------------------------------------*/
Frame save_load_frame;
Panel save_load_panel;
Panel_item save_load_panel_quit_item;
Panel_item save_data_item,load_data_item;
Panel_item file_name_item,dir_name_item;
Panel_item save_option_item;

/*-----------------------------------------------------------------------------
	Sunview Objects for the execution window
-----------------------------------------------------------------------------*/
Frame exec_frame;
Panel exec_panel;
Textsw exec_textsw;
Textsw_status exec_status;
Panel_item exec_panel_quit_item, exec_panel_go_item, exec_panel_load_item;
Panel_item exec_dir_name_item, exec_file_name_item, exec_input_name_item;

/*-----------------------------------------------------------------------------
	Sunview Objects for the auxiliary window
-----------------------------------------------------------------------------*/
Frame *aux_frame;
Panel *aux_panel;
Canvas *aux_canvas;
Cursor *aux_cursor;
Pixwin **aux_pw;
Panel_item *aux_quit_item;
Panel_item *aux_copy_item;
Panel_item *aux_win_mode_item;
Panel_item *aux_x_item;
Panel_item *aux_y_item;
Panel_item *aux_x_min_item;
Panel_item *aux_x_max_item;
Panel_item *aux_y_min_item;
Panel_item *aux_y_max_item;

/*-----------------------------------------------------------------------------
	Sunview Objects for the integration window
-----------------------------------------------------------------------------*/
Frame int_frame;
Pixwin *int_pw;
Panel int_panel;
Panel_item int_quit_item,int_driver_item,int_algorithm_item,int_option_item,int_nstep_item,int_max_nstep_item;
Panel_item int_start_item,int_end_item,int_period_item,int_eps_item,int_guessed_step_item,int_min_step_item,*int_yscal_item;

/*-----------------------------------------------------------------------------
	Sunview Objects for the periodic orbit (fixed point) window
-----------------------------------------------------------------------------*/
Frame fp_frame;
Pixwin *fp_pw;
Panel fp_panel;
Panel_item fp_quit_item,fp_go_item,fp_clear_item,fp_manifold_item,fp_show_item;
Panel_item fp_go_option_item,fp_display_option_item,fp_algorithm_item;
Panel_item fp_n_stored_fp_item,fp_ir_item;
Panel_item fp_sqzex_maxsq_item,fp_sqzex_eps_item,fp_sqzex_epsf_item,fp_sqzex_epsm_item,fp_mc_eps_item,fp_n_mc_item;
Panel_item fp_mu_item,fp_ms_item,fp_muf_item,fp_msf_item,fp_iskip_item,fp_gp_delm_item;
Panel_item fp_fi_eps_item,fp_fi_epsf_item,fp_fi_epsm_item,fp_fi_maxsq_item;

Panel_item fp_2manifold_item;

/*-----------------------------------------------------------------------------
	Sunview Objects for the print window
-----------------------------------------------------------------------------*/
Frame print_frame;
Panel print_panel;
Panel_item print_quit_item,print_print_item,print_option_item,print_region_item,print_lpr_item,print_graph_item;

/*-----------------------------------------------------------------------------
	Sunview Objects for the AUTO86 window
-----------------------------------------------------------------------------*/
Textsw auto_textsw;
Textsw_status auto_status;
Frame auto_frame;
Panel auto_panel;
Panel_item auto_panel_quit_item,auto_panel_go_item,auto_panel_load_item,auto_panel_write_init_item;
Panel_item auto_dir_name_item,auto_file_name_item,auto_input_name_item;
Panel_item auto_ndim_item,auto_ips_item,auto_irs_item,auto_ilp_item;
Panel_item auto_ntst_item,auto_ncol_item,auto_iad_item,auto_isp_item,auto_isw_item,auto_iplt_item;
Panel_item auto_nbc_item,auto_nint_item,auto_nmx_item,auto_npr_item,auto_mxbf_item,auto_iid_item;
Panel_item auto_itmx_item,auto_itnw_item,auto_nwtn_item,auto_jac_item,auto_nuzr_item;
Panel_item auto_nfpar_item,auto_icp_item[AUTO_NFPAR_MAX];
Panel_item auto_rl0_item,auto_rl1_item,auto_a0_item,auto_a1_item,auto_par_item[20];
Panel_item auto_epsu_item,auto_epss_item,auto_epsl_item[2],auto_ds_item,auto_dsmin_item,auto_dsmax_item;
Panel_item auto_thetau_item,auto_thetal_item[2];

/*-----------------------------------------------------------------------------
	Sunview Objects for the time series window
-----------------------------------------------------------------------------*/
Frame tser_frame;
Panel tser_panel;
Panel_item tser_quit_item,tser_copy_item,tser_clear_item;
Panel_item tser_fft_item,tser_lyap_item,tser_dims_item;
Panel_item tser_algorithm_option_item,tser_data_option_item;

/*-----------------------------------------------------------------------------
	Sunview Objects for the fft window
-----------------------------------------------------------------------------*/
Frame fft_frame;
Panel fft_panel;
Panel_item fft_quit_item,fft_go_item,fft_show_item;
Panel_item fft_algorithm_option_item;

/*-----------------------------------------------------------------------------
	Sunview Objects for the lyapunov window
-----------------------------------------------------------------------------*/
Frame lyap_frame;
Panel lyap_panel;
Panel_item lyap_quit_item,lyap_go_item;
Panel_item lyap_algorithm_option_item;

/*-----------------------------------------------------------------------------
	Sunview Objects for the dimensions window
-----------------------------------------------------------------------------*/
Frame dims_frame;
Panel dims_panel;
Panel_item dims_quit_item,dims_go_item,dims_analyze_item;
Panel_item dims_type_option_item,dims_algorithm_option_item;
Panel_item dims_scale_max_item,dims_scale_factor_item;
Panel_item dims_lsf_start_item,dims_lsf_end_item;

/*-----------------------------------------------------------------------------
	Sunview Objects for the scan window
-----------------------------------------------------------------------------*/
Frame scan_frame;
Panel scan_panel;
Textsw scan_textsw;
Textsw_status scan_status;
Panel_item scan_quit_item,scan_get_item,scan_go_item,scan_clear_item,scan_show_item;
Panel_item scan_list_type_item,scan_algorithm_option_item,scan_n_stored_item;
Panel_item scan_xgrid_item[3],scan_xmin_item[3],scan_xmax_item[3];

/*-----------------------------------------------------------------------------
	Sunview Objects for the help window
-----------------------------------------------------------------------------*/
Frame help_frame;
Panel help_panel;
Textsw help_textsw;
Textsw_status help_status;
Panel_item help_quit_item,help_option_item;

/*-----------------------------------------------------------------------------
	Sunview Objects for the menus
-----------------------------------------------------------------------------*/
Menu main_menu,param_menu,aux_menu,orbit_menu,open_menu,bif_menu,batch_menu;

