/*
### create windows for computing periodic orbits ###
*/

#include <suntool/sunview.h>
#include <suntool/panel.h>
void create_fp_windows()
{
        int ipanel_row=0;
	extern short fp_panel_show;
	extern int panel_colormap_on;
        extern int n_stored_fp,ir,fp_go_option,fp_display_option,fp_algorithm;
        extern int n_mc,sqzex_maxsq,fi_maxsq,mu,ms,muf,msf,iskip;
        extern double gp_delm,mc_eps,sqzex_eps,sqzex_epsf,sqzex_epsm;
        extern double fi_eps,fi_epsf,fi_epsm;
        void fp_quit_proc(),fp_go_proc(),fp_manifold_proc(),fp_2manifold_proc(),fp_clear_proc(),fp_show_proc(),fp_go_option_proc(),fp_display_option_proc(),fp_algorithm_proc();
        extern char string[];
        extern Pixfont *boldfont;
        extern Frame frame,fp_frame;
        extern Panel fp_panel;
        extern Panel_item fp_quit_item,fp_go_item,fp_clear_item,fp_manifold_item,fp_show_item;
        extern Panel_item fp_go_option_item,fp_display_option_item,fp_algorithm_item;
        extern Panel_item fp_n_stored_fp_item,fp_ir_item;
        extern Panel_item fp_sqzex_maxsq_item,fp_sqzex_eps_item,fp_sqzex_epsf_item,fp_sqzex_epsm_item,fp_mc_eps_item,fp_n_mc_item;
        extern Panel_item fp_mu_item,fp_ms_item,fp_muf_item,fp_msf_item,fp_iskip_item,fp_gp_delm_item;
        extern Panel_item fp_fi_eps_item,fp_fi_epsf_item,fp_fi_epsm_item,fp_fi_maxsq_item;
	extern Panel_item fp_2manifold_item;

	if(fp_panel_show){
		window_set(fp_frame,WIN_SHOW,TRUE,0);
		return;
	}
	else
		fp_panel_show = 1;
		
        fp_frame = window_create(frame,FRAME,FRAME_LABEL,"periodic orbit",
                FRAME_SHOW_LABEL,       TRUE,
                FRAME_NO_CONFIRM,       TRUE,
                WIN_SHOW,       TRUE,
                WIN_X, 400,
                WIN_Y, 0,
                WIN_FONT,       boldfont,
                0);
	if(fp_frame == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		fp_panel_show = 0;
		return;
	}
        fp_panel = window_create(fp_frame, PANEL,
                WIN_FONT,       boldfont,
                0);
	if(fp_panel == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		(void) destroy_fp_windows();
		return;
	}
        fp_quit_item= panel_create_item(fp_panel,PANEL_BUTTON,
                PANEL_LABEL_Y,  ATTR_ROW(ipanel_row++),
                PANEL_LABEL_X,  ATTR_COL(0),
                PANEL_LABEL_IMAGE,panel_button_image(fp_panel,"Quit",0,boldfont),
                PANEL_NOTIFY_PROC,fp_quit_proc,
                0);
        fp_go_item= panel_create_item(fp_panel,PANEL_BUTTON,
                PANEL_LABEL_IMAGE,panel_button_image(fp_panel,"Go",0,boldfont),                PANEL_NOTIFY_PROC,fp_go_proc,
                0);
        fp_manifold_item= panel_create_item(fp_panel,PANEL_BUTTON,
                PANEL_LABEL_IMAGE,panel_button_image(fp_panel,"Add 1D Man",0,boldfont),
                PANEL_NOTIFY_PROC,fp_manifold_proc,
                0);
        fp_2manifold_item= panel_create_item(fp_panel,PANEL_BUTTON,
                PANEL_LABEL_IMAGE,panel_button_image(fp_panel,"Add 2D Man",0,boldfont),
                PANEL_NOTIFY_PROC,fp_2manifold_proc,
                0);
        fp_clear_item= panel_create_item(fp_panel,PANEL_BUTTON,
                PANEL_LABEL_IMAGE,panel_button_image(fp_panel,"Clear",0,boldfont),
                PANEL_NOTIFY_PROC,fp_clear_proc,
                0);
        fp_show_item= panel_create_item(fp_panel,PANEL_BUTTON,
                PANEL_LABEL_IMAGE,panel_button_image(fp_panel,"Show-Hide",0,boldfont),
                PANEL_NOTIFY_PROC, fp_show_proc,
                0);
        fp_display_option_item= panel_create_item(fp_panel,PANEL_CYCLE,
                PANEL_LABEL_Y,  ATTR_ROW(ipanel_row++),
                PANEL_LABEL_X,  ATTR_COL(0),
                PANEL_DISPLAY_LEVEL,    PANEL_CURRENT,
                PANEL_LABEL_STRING,     "Display Option:",
                PANEL_CHOICE_STRINGS, "One copy","All copies",0,
                PANEL_VALUE, fp_display_option,
                PANEL_NOTIFY_PROC, fp_display_option_proc,
                0);
        fp_go_option_item= panel_create_item(fp_panel,PANEL_CYCLE,
                PANEL_LABEL_Y,  ATTR_ROW(ipanel_row++),
                PANEL_LABEL_X,  ATTR_COL(0),
                PANEL_LABEL_STRING,     "Go Option:",
                PANEL_CHOICE_STRINGS, "Mouse","Monte Carlo",0,
                PANEL_VALUE, fp_go_option,
                PANEL_NOTIFY_PROC, fp_go_option_proc,
                0);
        fp_algorithm_item= panel_create_item(fp_panel,PANEL_CYCLE,
                PANEL_LABEL_Y,  ATTR_ROW(ipanel_row++),
                PANEL_LABEL_X,  ATTR_COL(0),
                PANEL_DISPLAY_LEVEL,    PANEL_CURRENT,
                PANEL_LABEL_STRING,     "Algorithm:",
                PANEL_CHOICE_STRINGS, "Newton's Method","Secant Method", 0,
                PANEL_VALUE, fp_algorithm,
                PANEL_NOTIFY_PROC, fp_algorithm_proc,
                0);
        sprintf(string,"%d",n_stored_fp);
        fp_n_stored_fp_item= panel_create_item(fp_panel,PANEL_TEXT,
                PANEL_LABEL_Y,  ATTR_ROW(ipanel_row++),
                PANEL_LABEL_X,  ATTR_COL(0),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 7,
                PANEL_LABEL_STRING, "# Found:",
                0);
        sprintf(string,"%d",ir);
        fp_ir_item= panel_create_item(fp_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(23),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 7,
                PANEL_LABEL_STRING, "Period:",
                0);
        sprintf(string,"%d",n_mc);
        fp_n_mc_item= panel_create_item(fp_panel,PANEL_TEXT,
                PANEL_LABEL_Y,  ATTR_ROW(ipanel_row++),
                PANEL_LABEL_X,  ATTR_COL(0),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 7,
                PANEL_LABEL_STRING, "# MC:",
                0);
        sprintf(string,"%lg",mc_eps);
        fp_mc_eps_item= panel_create_item(fp_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(20),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 7,
                PANEL_LABEL_STRING, "MC tolx:",
                0);
        sprintf(string,"%lg",gp_delm);
        fp_gp_delm_item= panel_create_item(fp_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(37),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 7,
                PANEL_LABEL_STRING, "Del Man:",
                0);
        sprintf(string,"%d",iskip);
        fp_iskip_item= panel_create_item(fp_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(54),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 4,
                PANEL_LABEL_STRING, "# Skip:",
                0);
        sprintf(string,"%d",mu);
        fp_mu_item= panel_create_item(fp_panel,PANEL_TEXT,
                PANEL_LABEL_Y,  ATTR_ROW(ipanel_row++),
                PANEL_LABEL_X,  ATTR_COL(0),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 6,
                PANEL_LABEL_STRING, "U Max:",
                0);
        sprintf(string,"%d",muf);
        fp_muf_item= panel_create_item(fp_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(20),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 6,
                PANEL_LABEL_STRING, "U Div:",
                0);
        sprintf(string,"%d",ms);
        fp_ms_item= panel_create_item(fp_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(37),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 6,
                PANEL_LABEL_STRING, "S Max:",
                0);
        sprintf(string,"%d",msf);
        fp_msf_item= panel_create_item(fp_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(54),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 6,
                PANEL_LABEL_STRING, "S Div:",
                0);
        sprintf(string,"%d",sqzex_maxsq);
        fp_sqzex_maxsq_item= panel_create_item(fp_panel,PANEL_TEXT,
                PANEL_LABEL_Y,  ATTR_ROW(ipanel_row++),
                PANEL_LABEL_X,  ATTR_COL(0),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 6,
                PANEL_LABEL_STRING, "SqzeX-maxsq:",
                0);
        sprintf(string,"%lg",sqzex_eps);
        fp_sqzex_eps_item= panel_create_item(fp_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(20),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 7,
                PANEL_LABEL_STRING, "epsx:",
                0);
        sprintf(string,"%lg",sqzex_epsf);
        fp_sqzex_epsf_item= panel_create_item(fp_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(37),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 7,
                PANEL_LABEL_STRING, "epsf:",
                0);
        sprintf(string,"%lg",sqzex_epsm);
        fp_sqzex_epsm_item= panel_create_item(fp_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(54),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 7,
                PANEL_LABEL_STRING, "epsm:",
                0);
        sprintf(string,"%d",fi_maxsq);
        fp_fi_maxsq_item= panel_create_item(fp_panel,PANEL_TEXT,
                               PANEL_LABEL_Y,  ATTR_ROW(ipanel_row++),
                PANEL_LABEL_X,  ATTR_COL(0),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 6,
                PANEL_LABEL_STRING, "Fi-maxsq:",
                0);
        sprintf(string,"%lg",fi_eps);
        fp_fi_eps_item= panel_create_item(fp_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(20),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 7,
                PANEL_LABEL_STRING, "epsx:",
                0);
        sprintf(string,"%lg",fi_epsf);
        fp_fi_epsf_item= panel_create_item(fp_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(37),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 7,
                PANEL_LABEL_STRING, "epsf:",
                0);
        sprintf(string,"%lg",fi_epsm);
        fp_fi_epsm_item= panel_create_item(fp_panel,PANEL_TEXT,
                PANEL_LABEL_X,  ATTR_COL(54),
                PANEL_VALUE,    string,
                PANEL_VALUE_DISPLAY_LENGTH, 7,
                PANEL_LABEL_STRING, "epsm:",
                0);
        window_fit(fp_panel);
        window_fit(fp_frame);
	if(panel_colormap_on)
		init_panel_colormap((Pixwin *) window_get(fp_panel,WIN_PIXWIN),"fp_panel_cms");
}       
