/*
### create pipes ###
*/
#include <stdio.h>

void pipe_create(s,pid,from,to)
char s[];
int *pid,*from,*to;
{
	int pipeto[2],pipefrom[2];
	int c,numfds;
	FILE *popen();
	extern FILE *fp_fromchild,*fp_tochild;
	
	/* Create a pipe */
	if(pipe(pipefrom) < 0) {
                perror("new process");
		system_mess_proc(1,"Error: Pipe failed! Check the file name!");
		return;
	}
        if(pipe(pipeto) < 0){
                perror("new process");
		system_mess_proc(1,"Error: Pipe failed! Check the file name!");
		return;
	}

	/* Fork a child */
        switch (*pid = fork()){
                case -1:
                        perror("new process");
                        exit(1);
                case 0:
                        /* use dup2 to set the child's stdin and stdout to
                        the pipe */
                        dup2(pipeto[0],0);
                        dup2(pipefrom[1],1);

                        /* close all other fds (except stderr) since child
                        process doesn't know about or need them */
                        numfds = getdtablesize();
                        for (c = 3; c < numfds; c++)
                                close(c);
                        (void) execl("/bin/csh","csh","-c",s,0);
                        perror("new process: child");
                        exit(1);
                default:
                        close(pipeto[0]);
                        close(pipefrom[1]);
                        *to = pipeto[1];
                        fp_tochild = fdopen(*to, "w");
                        *from = pipefrom[0];
                        fp_fromchild = fdopen(*from, "r");

                        /* The pipe should be unbuffered or "new process" 
                        will not get any data until 1024 characters have
                        been sent */
                        setbuf(fp_tochild,NULL);
                        setbuf(fp_fromchild,NULL);
                        break;
        }
}
