/*
### get available combined space windows ###

Return: 0: do not recreate window (use existing one)
	1: create a new window with this index
	2: destroy window with this index and recreate it
Output: *t_aux_win_i: index of the auxiliary window
Indirect Output: if auto_option>0, aux_win_mode[*t_aux_win_i] is set to 1
		otherwise, 0.
*/

int get_available_aux_window(t_aux_win_i)
int *t_aux_win_i;
{
	int i,result;
	extern int aux_max;
	extern int *aux_on,*aux_win_mode;
	extern int auto_option;
	extern char auto_file_name[],error_mess[],error_yes[],error_no[];
	/* t_aux_win_i runs from 0 to aux_max-1 */
	/* Count the number of open auxiliary windows */
	for(i=0;i<aux_max;i++){
		if(!aux_on[i]){
			*t_aux_win_i = i;
			if(auto_option>0)
				aux_win_mode[i]=1;
			else
				aux_win_mode[i]=0;
			return(1);
		}
	}
	/* All the auxiliary windows are used up. Take over one. */
	for(i=0;i<aux_max;i++){
		if(i==0){
			sprintf(error_mess,"No more aux windows. RECREATE an existing aux_win[%d]?",i);
			sprintf(error_yes,"Confirm");
			if(i != aux_max-1){
				sprintf(error_no,"No. Move to next aux_win[%d]",i+1);
			}
			else {
				sprintf(error_no,"No, use current winsow as it is");
			}
		}
		else if(i<aux_max-1){
			sprintf(error_mess,"How about this aux_win[%d]?",i);
			sprintf(error_yes,"Confirm");
			sprintf(error_no,"Nope. Next!");
		}
		else {
			sprintf(error_mess,"This is the last chance. Do you want get aux_win[i]?",i);
			sprintf(error_yes,"Confirm");
			sprintf(error_no,"Cancel. Exit!");
		}
		result = (int) error_mess_proc(error_mess,error_yes,error_no);
		if(result){
			*t_aux_win_i = i;
			if(auto_option>0)
				aux_win_mode[i]=1;
			else
				aux_win_mode[i]=0;
			return(2);
		}
		else {
			if(i==0){
				*t_aux_win_i = i;
				if(auto_option>0)
					aux_win_mode[i]=1;
				else
					aux_win_mode[i]=0;
				return(0);
			}
		}
	}
}
