#include "poisson.h"

/************************************* MAIN ****************************************************/
/*
			poisson

			by

			Ithiel Carter
			Department of Mathematics
			University of California
			La Jolla, CA	92093
			(619) 450-9050
			icarter@ucsd.edu

			Copyright
			1989
			Ithiel Carter
			All rights reserved

	This program constructs circle packings having specified border radii.

	The user first fills the disk with the regular hexagonal circle packing of chosen mesh.

	If in the mode of Thurston boundary modification, circles overlapping the boundary 

	will be moved in until tangent to the boundary.

	The user then draws a curve representing relative border radii

	in the angle interval [-PI, PI].

	These border radii are assigned to the border vertices in the domain.

	A circle packing is then constructed having the specified border radii.

	This construction consists of solving a system of nonlinear curvature equations.

	The system is solved by a damped Newton's method calling the Yale sparse

	linear system solver ndrv().

*/
/***********************************************************************************************/


main(argc,argv)
int argc;
char **argv;
{
	int		newtoncount;

	/* Prompt user for boundary modification mode. */
	getoption();

	/* Open windows, draw the "unit" circle and fill it with
	the regular hexagonal circle packing */
	dofill(argc, argv);

	/* Open the window for drawing the boundary assignment curve */
	getdrawwin(argc, argv);

	/* Draw the boundary radius assignment curve */
	getbdry();
			
	/* Assign fixed border radii */
	assignrad();

	XSetLineAttributes(dpy, gc, 2, LineSolid, CapNotLast, JoinMiter);
	
	/* Initialize memory for Newton method */
	initNDRVargs();

	/* Do an N-dimensional Newton's method to construct the packing having the specified boundary radii */

	 for (newtoncount = 0; ; ++newtoncount)	{

		printf(" %d iterating...\n", newtoncount);

		/* Do one Newton iteration */
		mynewton(newtoncount);

		/* Check whether curvature is small enough or
		iterations have exceeded MAXITERATION */
		if ((newtoncount > MAXITERATION)	
		|| (maxkappa < TINY))	{

			/* Draw the range circle packing */
			plotpack();
			break;

		}
	}
	printf("Done. control c terminates\n");

	/* Deallocate memory */
	if (packingmode == SECTMODE)	
		endedge();
	endNDRVargs();
	endcircs();

	/* Wait while user gazes on in udder amazement at the
	beautiful pictures gawd and man have produced */
    	while (1) ;
} /*main*/

				
doinfo()	{
/* Print various error diagnostics; remove later */
	int	i, j;

	for (i=0; i<height; ++i)	{
		if (i%2 == 1)	printf("  ");
		for (j=0; j<width; ++j)	
			printf("%4d", DCirc[j+i*width].state);
		printf("\n");
	}
	printf("\n\n");
	sleep(17);
} /*doinfo*/
			
