#define		ROOT3		1.73205080756887729
#define		PI		3.1415926535897932
#define		TINY		1.0e-14				/* conditioner for singular matrices */
#define		X360DEGREES	23040				/* 360 degrees in the X drawing commands */
#define		MAXITERATION	14				/* maximum number of newton iterations; arbitrary */
#define		WINSIZE		500				/* square window width; set to approximately half of root window width */
#define		TANGENTMODE	1			
#define		SECTMODE	2			
#define		AVE_EDGES	4.5				/* Maximum average number of neighboring edges in region at a border vertex */

/* circle type flags */
#define		OUTSIDE		0
#define		CANDIDATE	1
#define		DEEPINSIDE	2
#define		INTERIOR	4
#define		OUTERBDRY	9
#define		PLOTTED		1
#define		NUMNBRS		6

#define		TRUE		1
#define		FALSE		0
#define		DRAWWIDTH	500		/* window drawwin dimensions */
#define		DRAWHEIGHT	160


/* Structure descibing a circle packing */
typedef	struct	circleinfo	{
	double	x, y;		/* Center of circle */
	double	r;		/* radius */
	int	state;		/* Flag describing whether the circle is, e.g., INTERIOR, INNERBDRY, etc. See circle type constants */
	int	cnum;		/* Index ordering the circles in this array */
	} circleinfo;

/* Structure descibing edges*/
typedef	struct	edgeinfo	{
	int 	cnum1;		/* circleinfo cnum of circle */
	int	cnum2;		/* circleinfo cnum of adjacent circle. cnum1 < cnum2 */
	double	angle;		/* prescribed angle intersection of circles */
	} edgeinfo;

