#include "extern.h"

/* all the following functions are involved in the newton step */

getkappa (ccnum, s, i, j)		/* Returns the curvature and partial derivatives determined by the radii s.	*/
double 	*s;				/* The neighboring radii */
int 	*ccnum;				/* The neighboring cnum indices */
int	i, j;				/* The position of the central circle in the circleinfo arrays, or (0,0) if a hole */
{
	double 		phisum, d0phisum, d1phisum, r0, r1, r2, r3, phi[6], d0phi[6], d1phi[6];
	int 		k, rownum, colnum;
	int		rownorm, colcount, jj, cnum0;
	rowpartial	myrow[7], arow;
	double		r0r1, r0r2, r1r2;

	jj = j+i*width;
	rownum = DCirc[jj].cnum;
	r0 = DCirc[jj].r;
	cnum0 = DCirc[jj].cnum;

	colcount = 0;
	rownorm = 0;
	for (k=0; k<6; ++k) 
		if (ccnum[k]>0) ++rownorm;
	++rownorm;

	for (k=0; k<NUMNBRS; ++k) {
		r1 = s[k];
		r2 = s[(k+1)%6];
		r3 = s[(k-1+6)%6];

		if ((packingmode == SECTMODE)	
		&& (DCirc[jj].state > DEEPINSIDE))	{
		/* At a circle near the boundary; neighboring circles might intersect.
		Compute angle in triangle of circle centers */
			double		capa, capb, capc, capu, capv, capw, phi01, phi02, phi12;
			double		theta, r0r0, r1r1, r2r2, t01, t02, t12;
			double		dudr0, dvdr0, dwdr0, dudr1, dwdr1, dvdr2, dwdr2;
			int		cnum3, cnum1, cnum2;
		
			double		capuu, capvv, capww, capy, phi03, phi13;
			double		r3r3, r0r3, r1r3, t03, t13;
			double		dvvdr0, dwwdr0, dwwdr1, dvvdr3, dwwdr3;
			double		man2, man3;

			cnum1 = ccnum[k];
			cnum2 = ccnum[(k+1)%6];
			cnum3 = ccnum[(k-1+6)%6];

			phi01 = getxangle(cnum0, cnum1);
			phi02 = getxangle(cnum0, cnum2);
			phi12 = getxangle(cnum1, cnum2);
			phi03 = getxangle(cnum0, cnum3);
			phi13 = getxangle(cnum1, cnum3);

			/* Compute triangle of centers */

			r0r0 = r0*r0;
			r1r1 = r1*r1;
			r2r2 = r2*r2;
			r3r3 = r3*r3;
			r0r1 = r0*r1;
			r0r2 = r0*r2;
			r1r2 = r1*r2;
			r0r3 = r0*r3;
			r1r3 = r1*r3;

			t01 = cos(phi01);
			t02 = cos(phi02);
			t12 = cos(phi12);
			t03 = cos(phi03);
			t13 = cos(phi13);

			capu = r0r0 + r1r1 + 2.0*r0r1*t01;
			capv = r0r0 + r2r2 + 2.0*r0r2*t02;
			capw = r0r0 + r0r1*t01 + r0r2*t02 - r1r2*t12;
			capvv = r0r0 + r3r3 + 2.0*r0r3*t03;
			capww = r0r0 + r0r1*t01 + r0r3*t03 - r1r3*t13;

			man2 = capw/sqrt(capu*capv);
			phi[k] = acos(man2);

			/* Compute partial derivatives */

			dudr0 = 2.0*(r0 + r1*t01);
			dvdr0 = 2.0*(r0 + r2*t02);
			dwdr0 = 2.0*r0 + r1*t01 + r2*t02;

			dudr1 = 2.0*(r1 + r0*t01);
			dwdr1 = r0*t01 - r2*t12;

			dvdr2 = 2.0*(r2 + r0*t02);
			dwdr2 = r0*t02 - r1*t12;

			dvvdr0 = 2.0*(r0 + r3*t03);
			dwwdr0 = 2.0*r0 + r1*t01 + r3*t03;

			dwwdr1 = r0*t01 - r3*t13;

			dvvdr3 = 2.0*(r3 + r0*t03);
			dwwdr3 = r0*t03 - r1*t13;

			/* Summands of the partial with respect to the central radius */
			d0phi[k] = (capw/2.0)*(capu*dvdr0 + capv*dudr0) - capu*capv*dwdr0;
			d0phi[k] = - d0phi[k]/( sqrt(capu*capv - capw*capw) *capu*capv);

			if (ccnum[k] > 0)	{
			/* This neighboring circle has variable radius, so
			must compute a partial with respect to this radius */
				colnum = ccnum[k];

				/* Partial with respect to a neighboring radius */
	    			man2 = (capw/2.0)*(capv*dudr1) - capu*capv*dwdr1;
	    			man2 = man2/( sqrt(capu*capv - capw*capw) *capu*capv);
	    			man3 = (capww/2.0)*(capvv*dudr1) - capu*capvv*dwwdr1;
	    			man3 = man3/( sqrt(capu*capvv - capww*capww) * capu*capvv);
				d1phi[k] = - man2 - man3;
				
				myrow[colcount].i = rownum;
				myrow[colcount].j = colnum;
				myrow[colcount].dr = d1phi[k];
				++colcount;
			} /*if*/
		}
		else	{
		/* The circles are tangent */
			r0r2 = (r0+r1)*(r0+r2);
			r1r2 = r1*r2;
			r0r1 = r0*r1;
	  		phi[k] = acos(1.0-2.0*r1r2/(r0r2));	/* Summands of curvature */

			/* Summands of the partial with respect to the central radius */
	    		d0phi[k] = r1r2*(2.0*r0+r1+r2) / (r0r2*sqrt (r0*r1r2*(r0+r1+r2)));

			if (ccnum[k] > 0)	{
			/* This neighboring circle has variable radius */
				colnum = ccnum[k];
				/* Partial with respect to neighboring variable radius */
				d1phi[k] = (-r0*r2 / ((r0+r1) *sqrt(r0r1*r2*(r0+r1+r2))))
				- (r0*r3 / ((r0+r1) *sqrt(r0r1*r3*(r0+r1+r3))));
	
				myrow[colcount].i = rownum;
				myrow[colcount].j = colnum;
				myrow[colcount].dr = d1phi[k];
				++colcount;
			} 
		}
	} 

	/* Sum angles of curvature and summands of the central partial derivative */
	phisum = d0phisum = 0;
	for (k=0; k<NUMNBRS; ++k) {
     		phisum += phi[k];
     		d0phisum += d0phi[k];
    	}
    	curvature[rownum] = phisum-2.0*PI;

	/* Check for largest curvature in absolute value */
	if (fabs(curvature[rownum]) > maxkappa)
		maxkappa = fabs(curvature[rownum]);

	myrow[colcount].i = rownum;
	myrow[colcount].j = rownum;
	myrow[colcount].dr = d0phisum;
	/* sort the nonzero partials in increasing j for the linear system solver ndrv() */
	for (i=0; i<rownorm-1; ++i)	{
		jj = -1;
		k = myrow[i].j;
		for (j=i+1; j<rownorm; ++j)	{
			if (myrow[j].j<k)	{
				k = myrow[j].j;
				jj = j;
			}
		}
		if (jj >= 0)	{
			arow = myrow[i];
			myrow[i] = myrow[jj];
			myrow[jj] = arow;
		}
	}
	for (i=0; i<rownorm; ++i)	{
		JA[JAindex] = myrow[i].j;
		A[JAindex] = myrow[i].dr;
		++JAindex;
	}
	IA[IAindex] = IAsum;
	IAsum += rownorm;
	++IAindex;
	IA[IAindex] = IAsum;
} /*getkappa*/

getvalues ()	{
/* Compute curvatures and their partials. */
	int			i, j, m, mystate[6], u, indx, mypos[6][2], mynum[6];
	double 			s[6];

	maxkappa = 0.0;
	for (i=0; i<height; ++i)	{
		for (j=0; j<width; ++j)	{
			indx = j+i*width;
			if ((DCirc[indx].state == INTERIOR) 
			|| (DCirc[indx].state == DEEPINSIDE)) {
			/* Must compute curvature and partials at this vertex */
				getccindices (i, j, mypos);
				for (m=0; m<NUMNBRS; ++m)	{
				/* Get neighboring radii and cnums */
					u = mypos[m][1]+mypos[m][0]*width;
					s[m] = DCirc[u].r;
					mynum[m] = DCirc[u].cnum;
				}
				getkappa (mynum, s, i, j);
			} 
		} 
	} 
	printf("Maximum |curvature| = %.14lf\n", maxkappa);
} /*getvalues*/


mynewton (itercount)
/* Compute an N-dimensional newton step */
int		itercount;
{
	int		i, j, k, vcount, fix, nonzerocount, colcount;
	double		d, lowratio, temp, stepsize;

	int		PATH, FLAG, ESP, NSP = 400*N;

	IAindex = JAindex = IAsum = 1;

	
	/* Get the values of the first partials and curvatures */
	getvalues ();

	PATH = (itercount == 0) ? 1 : 2;	

	/* Call the sparse linear system solver */
#ifdef CRAY
	NDRV(&N, &R[1], &C[1], &IC[1], &IA[1], &JA[1], &A[1], &curvature[1], &curvature[1], &NSP, &ISP[1], &RSP[1], &ESP, &PATH, &FLAG);
#else
	ndrv_(N, R, C, IC, IA, JA, A, curvature, curvature, NSP, ISP, RSP, ESP, PATH, FLAG);
#endif
	/* The Newton radius step vector has been returned in curvature */
	/* Check for errors */
	if (ESP < 0)
		printf("ESP flag from NDRV is %d. must increase working storage NSP\n",ESP);
	if (FLAG != 0)
		printf("Error flag from NDRV is %d\n",FLAG);

	/* If the full step yields negative radii, take only a partial step */
	lowratio = 1.00;
	for (i=0; i<N; i++)	{		
		if (curvature[i+1] < 0.0)	{
			temp = -DCirc[innerindex[i]].r/curvature[i+1];
			if (temp<lowratio)
				lowratio = temp;
		}
	}
	if (lowratio < 1.00)	 stepsize = 0.9*lowratio;
	else	stepsize = 1.0;

	/* Increment the packing radii */
	for (i=0; i<N; i++)	
		DCirc[innerindex[i]].r += stepsize*curvature[i+1];
} /*mynewton*/

