#include "extern.h"

/* The following functions output pictures to the screen */

drawdomain()	{
/* Draw the circle domain and its bounding curve */
	int		i, j, k, indx, diskdiam, diskrad;
	
	diskdiam = 0.9*WINSIZE;
	diskrad = diskdiam/2.0;
	XESetFlushGC(dpy, 0, NULL);
	XFlush(dpy);
	XClearWindow(dpy, domainwin);
	XSetForeground(dpy, gc, 1);

	/* Draw the bounding circle */
	i = j = WINSIZE/2.0 - diskrad;
	XDrawArc(dpy, domainwin, gc, i, j, diskdiam, diskdiam, 0, X360DEGREES);

	/* Draw the circles packing the curves interior */
	for (i=0; i<numcircles; ++i)	{
		j = DCirc[circindex[i]].x-fillrad;
		k = DCirc[circindex[i]].y-fillrad;
		XSetForeground(dpy, gc, mycolor[i]);
		if (packingmode == TANGENTMODE)	
		/* Draw circle */
			XFillArc(dpy, domainwin, gc, j, k, (int) (2*fillrad+1), (int) (2*fillrad+1), 0, X360DEGREES);
		else
		/* Draw arc */
			XDrawArc(dpy, domainwin, gc, j, k, (int) (2*fillrad+1), (int) (2*fillrad+1), 0, X360DEGREES);
	} 
	XFlush(dpy);
} /*drawdomain*/
				
drawrange()	{
/* Draw the range packing of the disk */
	int		i, j, k, diam;
	
	XESetFlushGC(dpy, 0, NULL);
	XClearWindow(dpy, rangewin);
	for (i=0; i<numcircles; ++i)	{
		j = RCirc[circindex[i]].x-RCirc[circindex[i]].r;
		k = RCirc[circindex[i]].y-RCirc[circindex[i]].r;
		diam = 2*RCirc[circindex[i]].r;
		XSetForeground(dpy, gc, mycolor[i]);
		/* Draw circle */
		XDrawArc(dpy, rangewin, gc, j, k, diam+1, diam+1, 0, X360DEGREES);
	}
} /*drawrange*/

plotpack()	{
	int	indx;
	double	winrad, scale, delx, dely, maxd;

	winrad = WINSIZE/2.0;

	printf("plotting...\n");

	/* Given radii, find range circle centers */
	findcenters();
	indx = nullj+nulli*width;

	/* Translate range circles until nullcircle is centeredat the origin */
	translate(RCirc, -RCirc[indx].x, -RCirc[indx].y);

	/* Rotate the range packing until the circle to the right of the nullcircle
	lies on the positive real axis */
	twist(RCirc[indx+1].x, RCirc[indx+1].y);

	/* Find bounding rectangle of range */
	getrangerect();

	delx = -(umax+umin)/2.0;
	dely = -(vmax+vmin)/2.0;

	/* Center range at origin */
	translate(RCirc, delx, dely);

	/* Find bounding rectangle of range */
	getrangerect();
	delx = (umax-umin)/2.0;
	dely = (vmax-vmin)/2.0;
	if (delx>dely)	maxd = delx;
	else		maxd = dely;
	scale = winrad/maxd;

	/* Scale range packing and translate into range window */
	scalecircs(RCirc, scale);
	getrangerect();
	translate(RCirc, winrad, winrad);
	getrangerect();

	/* Draw the range packing */
	drawrange();
} /* plotpack */
