/* $Id$
 *
 * recenter.c
 */

/**************************************************************************
 *     Copyright (C) 1990 by Mark B. Phillips and Robert R. Miner	  *
 * 									  *
 * Permission to use, copy, modify, and distribute this software, its	  *
 * documentation, and any images it generates for any purpose and without *
 * fee is hereby granted, provided that					  *
 * 									  *
 * (1) the above copyright notice appear in all copies and that both that *
 *     copyright notice and this permission notice appear in supporting	  *
 *     documentation, and that the names of Mark B.  Phillips, Robert R.  *
 *     Miner, or the University of Maryland not be used in advertising or *
 *     publicity pertaining to distribution of the software without	  *
 *     specific, written prior permission.				  *
 *									  *
 * (2) Explicit written credit be given to the authors Mark B.  Phillips  *
 *     and Robert R. Miner in any publication which uses part or all of	  *
 *     any image produced by this software.				  *
 *									  *
 * This software is provided "as is" without express or implied warranty. *
 **************************************************************************/

#include <stdio.h>
#include "internal.h"
#include "../hcore.h"

static int Recenter();

static Pixrect *normal, *working;

static Panel_item recenter_button;

int
  wSetRecenterPixrects(button, n, w)
Panel_item button;
Pixrect *n, *w;
{
  recenter_button = button;
  normal = n;
  working = w;
}

int
  wRecenter()
{
  wMessage("Pick new viewport center");
  panel_set(recenter_button, PANEL_LABEL_IMAGE, working, 0);
  wGetXY0(Recenter, SELECT_IN_BOTH);
}

static int
  Recenter(x,y,valid)
double x,y;
int valid;
{
  hWindow hw;
  R2Point offset;
  int i;
  
  wMessage(NULL);
  if (valid) {
    GethWindow(&hw);
    offset[0] = x - hw.center[0];
    offset[1] = y - hw.center[1];
    TranslateR2Point(hw.center, offset);
    for (i=0; i<4; ++i)
      TranslateR2Point(hw.corner[i], offset);
    SethWindow(&hw);
  }
  
  panel_set(recenter_button, PANEL_LABEL_IMAGE, normal, 0);
}

static int
  TranslateR2Point(p, v)
R2Point p,v;
{
  int i;

  for (i=0; i<2; ++i)
    p[i] += v[i];
}
