/* $Id$
 *
 * hcore.h
 */

#include <math.h>

/**************************************************************************
 *     Copyright (C) 1990 by Mark B. Phillips and Robert R. Miner	  *
 * 									  *
 * Permission to use, copy, modify, and distribute this software, its	  *
 * documentation, and any images it generates for any purpose and without *
 * fee is hereby granted, provided that					  *
 * 									  *
 * (1) the above copyright notice appear in all copies and that both that *
 *     copyright notice and this permission notice appear in supporting	  *
 *     documentation, and that the names of Mark B.  Phillips, Robert R.  *
 *     Miner, or the University of Maryland not be used in advertising or *
 *     publicity pertaining to distribution of the software without	  *
 *     specific, written prior permission.				  *
 *									  *
 * (2) Explicit written credit be given to the authors Mark B.  Phillips  *
 *     and Robert R. Miner in any publication which uses part or all of	  *
 *     any image produced by this software.				  *
 *									  *
 * This software is provided "as is" without express or implied warranty. *
 **************************************************************************/

typedef double R2Point[2];

typedef R2Point kPoint;

typedef struct kSegment_s {
  kPoint p[2];
} kSegment;

typedef struct hWindow_s {
  R2Point center;
  R2Point corner[4];
} hWindow;

#define KLEIN		1
#define POINCARE	2
#define UHP		3

#define ERROR           -1
#define FUDGE           0.000001

#define PI_HALVES	(M_PI/2)
#define TWO_PI		(2*M_PI)

#define SQR(x) ((x)*(x))
#define ABS(x) (((x) < 0.0) ? (-(x)) : (x))
#define UHP_INFINITY(x) (x[1]==99999.0)
 
double SegmentSegmentDist();
double PointGeoSegmentDist();
double PointPointDist();
double PointLineDist();
double PointArcDist();
double R2distsq();
double R2dist();
double normsq();
double norm();

int hWindowToViewport();
int SethWindow();
int GethWindow();
int PSOutput();
int SethModel();
int GethModel();
int PoincareToKlein();
int KleinToPoincare();
int UHPToPoincare();
int PoincareToUHP();
int UHPToKlein();
int KleinToUHP();
int UHPGeoCenter();
int PoincareGeoCenter();
