./"
./"  gdbintro.man: introductory man page for GDB
./"
./"   $Id: gdbintro.man,v 1.2 90/07/11 13:10:41 mbp Exp Locker: mbp $
./"
./"		       This file is part of GDB
./"
./" ************************************************************************
./" *		Copyright (C) 1989 by Mark B. Phillips                     *
./" * 									   *
./" * Permission to use, copy, modify, and distribute this software and    *
./" * its documentation for any purpose and without fee is hereby granted, *
./" * provided that the above copyright notice appear in all copies and    *
./" * that both that copyright notice and this permission notice appear in *
./" * supporting documentation, and that the name of Mark B. Phillips or   *
./" * the University of Maryland not be used in advertising or publicity   *
./" * pertaining to distribution of the software without specific, written *
./" * prior permission.  This software is provided "as is" without express *
./" * or implied warranty.                                                 *
./" ************************************************************************
./"
.TH GDBINTRO 3X "August 22, 1988"
.SH NAME
gdbintro - introduction to GDB
.SH DESCRIPTION
.PP
GDB is a database manager.  It is a library of routines which maintain
a database of arbitrary data objects.  The "G" stands for "Geometry",
and is meant to indicate that GDB is particularly well suited (but not
limited) to managing databases of geometric objects.
.PP
The database provided by GDB has two levels.  The lower level consists
of the individual entries in the database; these are called
.I entities.
Each entry in the higher level is called a
.I block,
and consists of a collection of entities.  Blocks can be manipulated
in much the same way as entities; this provides a way to refer to an
collection of entities as one single object.  The same entity may be
a part of more than one block, but blocks may not contain other
blocks. Throughout the
documentation for GDB, the word
.I object
will be used to denote either a block or an entity.  
.PP
GDB can manage databases with up to 32 different types of entities.
Each entity corresponds to a particular data structure.  The
application program communicates information about these data types to
GDB by providing procedures named
.I gdb_entity_data_size,
.I gdb_entity_data_copy,
and
.I gdb_entity_data_dist.
These procedures must be present in your application program at the
time of linking; GDB calls them in order to perform operations on your
data objects.  See the section below entitled
.B SPECIFYING ENTITIES
for details.
.SH HANDLES, NAMES, AND TYPES
When an object is entered into the database, GDB returns a "handle"
for that object.  This handle is used in later calls to GDB procedures
to identify that object.  There are also GDB procedures for retrieving the
handle of an object based the object's attributes.  The 
data type for an entity handle is
.I gdb_Entity,
and the type for a block handle is
.I gdb_Block.
The special value NULL is used as the value of a handle which refers
to no object.  Several GDB procedures return NULL handles as a way of
indicating a special kind of result (usually a failure of some sort).
.PP
Each object also has a name which is specified when it is entered
into the database.  This name is simply an arbitrary null-terminated
ascii character string.  The name can be used to retrieve the object's
handle later.
.PP
Each entity has a "type" flag which tells which type of entity it is.
These flags are values of data type 
.I gdb_Entity_type.
This type flag
can take on the 32 values GDB_ENTITY_TYPE_1 through
GDB_ENTITY_TYPE_32.  The value of a type flag has no numerical
significance; it is only used to distinguish one type from another.
.PP
Blocks do not have types.  A block is a collection of entities, which
need not be of the same type.
.SH SPECIFYING ENTITIES
A GDB entity actually consists of the data which is specified when
that entity is entered into the database, plus a name and a type flag.
Since the "data" part of an entity can be different for each type of
entity, your application program must provide GDB with a way of
obtaining information about and manipulating this data.  This
is done by providing three procedures which perform basic operations
with entity data.  These procedures are:
.sp
.nf
.B gdb_entity_data_size(type)
.B   gdb_Entity_type type;
.sp
.B gdb_entity_data_copy(a,b,type)
.B   char *a,*b;
.B   gdb_Entity_type type;
.sp
.B double gdb_entity_data_dist(a,type_a,b,type_b)
.B   char *a,*b;
.B   gdb_Entity_type type_a, type_b;
.fi
.PP
.I gdb_entity_data_size
should return an
.I int
which is the size, in bytes, of the data for an entity of type
.I type.
It should return 0 for all values of 
.I type
other than the ones your application uses.
.I gdb_entity_data_copy
should copy one entity data item of type
.I type
to another.
.B b
is a pointer to the data to be copied (source), and
.B a
is a pointer to the location to be written into (destination).
.B a
and
.B b
should be declared as pointers to
.B char
because this is the most "general" type of pointer.  The actual data
to which these pointers point will vary from call to call and is
determined by the value of
.I type.
.I gdb_entity_data_dist
should return the distance between two entities.
.B a
and
.B b
are both pointers to entity data items, whose types are given by
.B type_a
and
.B type_b.
GDB uses this function when retrieving an object based on its distance
to another object.  If your applicaton uses certain types of entities
for which there is no notion of distance,
.I gdb_entity_data_dist
can return the value GDB_INFINITY when called with arguments of these
types.
.SH "SEE ALSO"
gdb(3X)
.SH AUTHOR
Mark Phillips
.br
Department of Mathematics
.br
University of Maryland
.br
College Park, Maryland  20742
.br
mbp@lakisis.umd.edu
.br
(301) 454-6550
