(* $Id: Triangle.m,v 1.3 90/07/11 13:08:34 mbp Exp Locker: mbp $
 *
 * Triangle.m: Functions for computing and drawing equilateral triangles.
 *)

(**************************************************************************
 *     Copyright (C) 1990 by Mark B. Phillips and Robert R. Miner	  *
 * 									  *
 * Permission to use, copy, modify, and distribute this software, its	  *
 * documentation, and any images it generates for any purpose and without *
 * fee is hereby granted, provided that					  *
 * 									  *
 * (1) the above copyright notice appear in all copies and that both that *
 *     copyright notice and this permission notice appear in supporting	  *
 *     documentation, and that the names of Mark B.  Phillips, Robert R.  *
 *     Miner, or the University of Maryland not be used in advertising or *
 *     publicity pertaining to distribution of the software without	  *
 *     specific, written prior permission.				  *
 *									  *
 * (2) Explicit written credit be given to the authors Mark B.  Phillips  *
 *     and Robert R. Miner in any publication which uses part or all of	  *
 *     any image produced by this software.				  *
 *									  *
 * This software is provided "as is" without express or implied warranty. *
 **************************************************************************)

Needs["Hypercad`"]

gConnect[]

GetTriangle[] :=
  Block[ {a,b,c,sa,sb,sc},
    gDraw[a = gGetPoint["Pick first vertex of triangle"]];
    gDraw[b = gGetPoint["Pick second vertex of triangle"]];
    gDraw[sc = kSegment[a, b]];
    gDraw[c = gGetPoint["Pick final vertex of triangle"]];
    gDraw[sa = kSegment[b, c]];
    gDraw[sb = kSegment[c, a]];
    Return[ {a,b,c} ]
    ]

AngleBisector[{a_, b_, c_}] :=
  hApply[ hRotation[b, hAngle[ hLog[ b, c ], hLog[ b, a ] ] / 2 ],
          kLine[b,c] ]

AngleBisectorSegment[{a_, b_, c_}] :=
  kSegment[ b, hIntersection[ kLine[ a ,c ], AngleBisector[ {a, b, c} ] ] ]

TriangleAngleBisectors[t_List] :=
  Table[ AngleBisectorSegment[ RotateRight[t,i] ], {i,0,2} ] /; Length[t] == 3

EdgeBisectorSegment[{a_, b_, c_}] :=
  kSegment[ b, hMidPoint[ a, c ] ]

Altitude[{a_, b_, c_}] :=
  hPerp[ kLine[a, c],  b ]

TriangleEdgeBisectors[t_List] :=
  Table[ EdgeBisectorSegment[ RotateRight[t,i] ], {i,0,2} ] /; Length[t] == 3

TriangleAltitudes[t_List] :=
  Table[ Altitude[ RotateRight[t,i] ], {i,0,2} ] /; Length[t] == 3

DrawAngleBisectedTriangle[] :=
  Block[ {t,bisectors},
    t = GetTriangle[];
    gDraw[ bisectors = TriangleAngleBisectors[t] ]
  ]

DrawEdgeBisectedTriangle[] :=
  Block[ {t,bisectors},
    t = GetTriangle[];
    gDraw[ bisectors = TriangleEdgeBisectors[t] ]
  ]

r = hRotation[ kPoint[0,0], N[2Pi/3] ]

v = hUnitVector[ kTangentVector[ kPoint[0,0], {1,0} ] ]

triangle[x_] :=
  Block[ {a,b,c},
    a = hExp[ x v ];
    b = hApply[r, a];
    c = hApply[r, b];
    Return[ {kSegment[a,b], kSegment[b,c], kSegment[c,a]} ]
  ]

gClear[]

(* Do[ gDraw[triangle[x]], {x,0.1,5.1,0.25} ] *)
