/* $Id: lgd.h,v 1.7 89/09/20 17:49:15 mbp Exp $
 *
 * lgd.h: application program header file for LGD
 */

/***************************************************************************
 *                Copyright (C) 1990 by Mark B. Phillips                   *
 *                                                                         *
 *  Permission to use, copy, modify, and distribute this software, its     *
 *  documentation, and any images it generates for any purpose and without *
 *  fee is hereby granted, provided that                                   *
 *                                                                         *
 *  (1) the above copyright notice appear in all copies and that both      *
 *      that copyright notice and this permission notice appear in         *
 *      supporting documentation, and that the names of Mark B.            *
 *      Phillips, or the University of Maryland not be used in             *
 *      advertising or publicity pertaining to distribution of the         *
 *      software without specific, written prior permission.               *
 *                                                                         *
 *  (2) Explicit written credit be given to the author Mark B. Phillips    *
 *      in any publication which uses part or all of any image produced    *
 *      by this software.                                                  *
 *                                                                         *
 * This software is provided "as is" without express or implied warranty.  *
 ***************************************************************************/

/* Colors: */
#define LGD_BLACK	0
#define LGD_WHITE	1
#define LGD_RED		2
#define LGD_GREEN	3
#define LGD_YELLOW	4
#define LGD_BLUE	5
#define LGD_MAGENTA	6
#define LGD_CYAN	7
/* NOTE: LGD_BLACK is always invisible, and LGD_WHITE is always the
   opposite of whatever the background is. */

/* Viewing data typedef: */
typedef struct lgd_View3_s {
  double eye[3];
  double focus[3];
  double up[3];
  double u1,u2,v1,v2,h1,h2;
} lgd_View3;

/* "Pointer to Function returning Int": */
typedef          int  (*lgd_PFI)();

/* Menu typedefs: */
typedef struct lgd_Opt_pair_s {
	char	*string;
	lgd_PFI	proc;
	} lgd_Opt_pair;
typedef struct lgd_Menu_s {
	char	 *title;
	int	 nopts;
	lgd_Opt_pair *list;
	} lgd_Menu;

/* I/O buffer type: */
typedef char lgd_Buf[70];

/* Global error flag: */
char *lgd_error;

/* Functions: */
char *lgd_get_string();
double lgd_get_pick_tolerance();
