/* $Id: transf_math.c,v 4.0 89/06/06 15:38:55 mbp Exp $
 *
 * transf_math.c: transformation procedures
 */

/***************************************************************************
 *                          Copyright (C) 1990 by                          *
 *        Mark B. Phillips, William M. Goldman, and Robert R. Miner        *
 *                                                                         *
 *  Permission to use, copy, modify, and distribute this software, its     *
 *  documentation, and any images it generates for any purpose and without *
 *  fee is hereby granted, provided that                                   *
 *                                                                         *
 *  (1) the above copyright notice appear in all copies and that both that *
 *      copyright notice and this permission notice appear in supporting   *
 *      documentation, and that the names of Mark B.  Phillips, William M. *
 *      Goldman, Robert R.  Miner, or the University of Maryland not be    *
 *      used in advertising or publicity pertaining to distribution of the *
 *      software without specific, written prior permission.               *
 *                                                                         *
 *  (2) Explicit written credit be given to the authors Mark B. Phillips,  *
 *      William M. Goldman, and Robert R. Miner in any publication which   *
 *      uses part or all of any image produced by this software.           *
 *                                                                         *
 * This software is provided "as is" without express or implied warranty.  *
 ***************************************************************************/

#include "heisenberg.h"

/*-----------------------------------------------------------------------
 * Function:     hpoint_translate
 * Description:  Heisenberg-translate a Hpoint
 * Arguments IN: *p2: the Hpoint to be translated
 *               *d: the Heisenberg vector to translate by
 *          OUT: *p1: the result of translating *p2 by *d
 * Returns:      nothing
 * Notes:        
 */
hpoint_translate(p1,p2,d)
Hpoint *p1,*p2,*d;
{
  (p1->hor.re) = (p2->hor.re) + (d->hor.re);
  (p1->hor.im) = (p2->hor.im) + (d->hor.im);
  (p1->hor.inf) = (p2->hor.inf);
  (p1->ver) = (p2->ver) + (d->ver)
              + (p2->hor.im)*(d->hor.re) - (p2->hor.re)*(d->hor.im);
}

/*-----------------------------------------------------------------------
 * Function:     hpoint_dilate
 * Description:  dilate Hpoint about the origin
 * Arguments IN: *p2: the Hpoint to be dilated
 *               *c: the complex dilation factor
 *          OUT: *p1: the result of dilating *p2 by *c
 * Returns:      nothing
 * Notes:        
 */
hpoint_dilate(p1,p2,c)
Hpoint *p1,*p2;
Complex *c;
{
  (p1->hor.re) = (p2->hor.re)*(c->re) - (p2->hor.im)*(c->im);
  (p1->hor.im) = (p2->hor.im)*(c->re) + (p2->hor.re)*(c->im);
  (p1->hor.inf) = (p2->hor.inf);
  (p1->ver) = (p2->ver) * c_enorm_sq(c); 
}

