/*
 * texts.c: text submodule
 */

/***************************************************************************
 *                Copyright (C) 1990 by Mark B. Phillips                   *
 *                                                                         *
 *  Permission to use, copy, modify, and distribute this software, its     *
 *  documentation, and any images it generates for any purpose and without *
 *  fee is hereby granted, provided that                                   *
 *                                                                         *
 *  (1) the above copyright notice appear in all copies and that both      *
 *      that copyright notice and this permission notice appear in         *
 *      supporting documentation, and that the names of Mark B.            *
 *      Phillips, or the University of Maryland not be used in             *
 *      advertising or publicity pertaining to distribution of the         *
 *      software without specific, written prior permission.               *
 *                                                                         *
 *  (2) Explicit written credit be given to the author Mark B. Phillips    *
 *      in any publication which uses part or all of any image produced    *
 *      by this software.                                                  *
 *                                                                         *
 * This software is provided "as is" without express or implied warranty.  *
 ***************************************************************************/

#include <stdio.h>
#include <ctype.h>		/* needed for 'isprint' */
#include <device.h>
#include <get.h>
#include "glg.h"
#include "internal.h"
#include "texts.h"

static int (*DrawWindow)() = NULL;

/*-----------------------------------------------------------------------
 * Function:	GlgTextInit
 * Description:	initialize the text subpackage
 * Args  IN:	drawwindow: procedure for redrawing entire window.
 *		  Call syntax is just 'drawwindow()'.
 * Returns:	nothing
 * Author:	mbp
 * Date:	Mon Jun  4 14:12:16 1990
 * Notes:	Call this once before processing any gadget events.
 */
int
  GlgTextInit(drawwindow)
int (*drawwindow)();
{
  DrawWindow = drawwindow;
}

/*-----------------------------------------------------------------------
 * Function:	GlgTextDraw
 * Description:	draw a text
 * Args  IN:	*data: the text to draw
 * Returns:	nothing
 * Author:	mbp
 * Date:	Mon Jun  4 17:25:31 1990
 */
int
  GlgTextDraw(data)
char *data;
{
  register GlgText *tp = (GlgText*)data;
  double x1,y1,x2,y2, cx1,cy1,cx2,cy2;

  /* Draw the string */
  GlgWriteString(tp->string, tp->x, tp->y, 0, 0, 1, tp->bgnd, tp->txtcol);

  /* Draw the cursor, if there's room */
  if (strlen(tp->string) < tp->maxlen-1) {
    cy1 = tp->y - GLGWYLEN(getdescender()-1);
    cy2 = tp->y + GLGWYLEN(getheight()-1);
    cx1 = tp->x + GLGWXLEN(strwidth(tp->string)+1);
    cx2 = cx1 + GLGWXLEN(strwidth("M")-1);
    color(tp->txtcol);
    rectf(cx1, cy1, cx2, cy2);
  }

  /* Draw the outline box */
  y1 = tp->y - GLGWYLEN(getdescender()+1);
  y2 = tp->y + GLGWYLEN(getheight()+1);
  x1 = tp->x - GLGWXLEN(1);
  x2 = x1 + GLGWXLEN((tp->maxlen-1)*strwidth("M"));
  color(tp->outline);
  rect(x1, y1, x2, y2);
}
 

/*-----------------------------------------------------------------------
 * Function:	GlgTextEvent
 * Description:	Let a text process an event
 * Args  IN:	*data: the text
 *		event: the event
 * Returns:	1 if the text acts on the event, 0 if not.
 * Author:	mbp
 * Date:	Mon Jun  4 17:26:53 1990
 */
int
  GlgTextEvent(data, event)
register char *data;
GlgEvent event;
{
  register GlgText *tp = (GlgText*)data;
  int len;
  double xsz, ysz;

  xsz = GLGWXLEN((tp->maxlen-1) * strwidth("M"));
  ysz = GLGWYLEN(getheight());

  if (!GlgEventInRect(event, tp->x, tp->y, xsz, ysz))
    return(0);
  
  switch (event.dev) {
  case KEYBD:

    len = strlen(tp->string);

    switch (event.val) {
    case GlgDEL:
    case '\b':		/* val = backspace: back up one char. */
      if (len > 0) {
	tp->string[len-1] = '\0';
	(*DrawWindow)();
      }
      break;
    case GlgCTRL_U:	/* val = ctrl-u: erase line and start over. */
      tp->string[0] = '\0';
      (*DrawWindow)();
      break;
    case GlgCTRL_J:
    case GlgRET:
      break;
    default:		/* val = <other>: */
      if (isprint((int)event.val)) {
	if (strlen(tp->string) < tp->maxlen-1) {
	  tp->string[len] = event.val;
	  tp->string[len+1] = '\0';
	}
	(*DrawWindow)();
      }
      break;
    }
    break;

  case MIDDLEMOUSE:
    if (DrawWindow != NULL) {

      double xold = event.x;
      int first = 1;
      while (getbutton(event.dev)) {
	GlgGetMouseXY(&event.x,&event.y);
	if ((first) || (event.x != xold)) {
	  first = 0;
	  xold = event.x;
	  tp->x = event.x;
	  tp->y = event.y;
	  (*DrawWindow)();
	}
      }
    }
    break;
    
  case RIGHTMOUSE:
    if (getbutton(RIGHTMOUSE))
      printf("text is at (%5.3f, %5.3f)\n", tp->x,tp->y);
    break;
  }
  
  return(1);
}

