
/*
  $Header: /usr4/Geom_utilities/Tsum/RCS/process_numbers.c,v 1.1 91/03/12 16:44:22 meuer Exp $
  
  
  Read in a list of polygons and feed them one-by-one into the routine that will break them
  into triangles.
  
  Mark Meuer
  #1267045
  
  */

#include	"tsum.h"

void
process_numbers( in_file, out_file, chunk_size )
     FILE 	*in_file, *out_file;
     int	chunk_size;
{
    int	success = TRUE;
    int	current_chunk_count = 0;
    double	sum = 0.0;
    double	number;
    
    /* WHILE NOT AT THE END OF THE LIST, */
    while( (!feof( in_file )) && (success) )
    {
	/* READ ONE NUMBER */
	success = fscanf(in_file, "%lf", (double *) &number);
	
	/* IF SUCCESSFUL, */
	if (success == 1) 
	{
	    /* ADD TO THE CURRENT SUM */
	    sum += number;
	    current_chunk_count++;
	    
	    /* IF THE CURRENT SUM IS FULL, */
	    if ( current_chunk_count == chunk_size )
	    {
		/* PRINT IT OUT */
		fprintf(out_file, "%lf\n", (double) sum );
		sum = 0.0;
		current_chunk_count = 0;
	    }
	}
	else if ( !feof( in_file ) )
	{
	    fatal_error("Non-numeric character on input!  Bye.\n");
	    exit(-1);
	}
    }
    
    if (( chunk_size == 0 ) || ( current_chunk_count != 0 ))
    {
	fprintf(out_file, "%lf\n", (double) sum );
    }
    if (( chunk_size != 0 ) && ( current_chunk_count != 0 ))
    {
	fprintf(stderr, "Warning:  Incomplete last group.\n");
	fprintf(stderr, "Last sum is of last %d numbers.\n", current_chunk_count);
    }
    fflush(stdout);
}
