
/*
  $Header: /usr4/Geom_utilities/Poly2tri/RCS/sort_vert.c,v 1.1 91/03/04 11:24:32 meuer Exp $


  Sort the polygon verticies into clockwise order.  Returns TRUE if order of verticies was changed.

  Mark Meuer
  #1267045

  */

#include	"poly2tri.h"

int
sort_verticies( poly )
     Polygon	*poly;
{
    Float	area;
    Vertex	*vert;
    Vertex	*temp_next_vert;
    int		order_changed = FALSE;
    
    /* COMPUTE THE AREA OF THE POLYGON */
    area = 0.0;
    vert = poly->top_vertex;
    do
    {
	area += ((vert->plane_coords[0] * vert->next_vertex->plane_coords[1])
		 - (vert->plane_coords[1] * vert->next_vertex->plane_coords[0]));

	vert = vert->next_vertex;
    } while ( vert != poly->top_vertex );
    area *= 0.5;	/* I realize this isn't really needed since we will only be looking
			   at the sign of the area.  I'm putting it here so that if we ever try
			   to use the value of area in the future I won't be messed up by
			   thinking it is the actual area when it wasn't. */
    
    /* IF AREA IS POSITIVE, */
    if ( area > 0.0 )
    {
	/* REVERSE THE ORDER OF THE VERTICIES */
	order_changed = TRUE;	/* Flag the fact we changed direction */
	vert = poly->top_vertex;
	do
	{
	    temp_next_vert = vert->next_vertex;
	    vert->next_vertex = vert->prev_vertex;
	    vert->prev_vertex = temp_next_vert;

	    vert = temp_next_vert;
	} while ( vert != poly->top_vertex );
    }	

    return(order_changed);	/* Returns TRUE if order of verticies was reversed */
}
