
/*
  $Header: /usr2/meuer/Geom_utilities/Poly2tri/RCS/point_in_tri.c,v 1.1 91/02/14 15:34:09 meuer Exp $

  Check to see if a point lies within a triangle.

  The basic algorithm is to draw a line from the first vertex to the point in question and find
  out where that intersects the opposite side.  If the point of intersection lies outside of the
  segment from the first point to the test point and inside the other segment, then the point
  is inside the triangle.

  Mark Meuer
  #1267045

  */

#include	"poly2tri.h"

int
point_in_triangle( tri1, tri2, tri3, test_point )
     Point	tri1, tri2, tri3;	/* Verticies of the triangle */
     Point	test_point;
{
    Float	t;	/* t is parameter for segment from tri1 to the test point */
    Float	r;	/* r is parameter for segment from tri2 to tri3 */
    Float	denom;	/* Eqn's have a common denomenator */
    int		found;	/* Success flag */

    /* SOLVE FOR t */
    /*
      Note:  I know these equations look horrible.  But I got them from Mathematica, and didn't
      feel like going to the work to simplify them more.  Sorry.
      */
    found = FALSE;
    denom = (-(test_point[1]*tri2[0]) + test_point[1]*tri3[0] + tri2[0]*tri1[1] - tri3[0]*tri1[1]
	     + test_point[0]*tri2[1] - tri1[0]*tri2[1] - test_point[0]*tri3[1] + tri1[0]*tri3[1]);
    t = (tri2[0]*tri1[1] - tri3[0]*tri1[1] - tri1[0]*tri2[1] + tri3[0]*tri2[1]
	 + tri1[0]*tri3[1] - tri2[0]*tri3[1]) / denom;

    /* IF INTERSECTION IS BEYOND THE TEST POINT, */
    if ( t >= 1.0 )
    {
	/* SOLVE FOR r */
	r = (test_point[1]*tri1[0] - test_point[1]*tri2[0] - test_point[0]*tri1[1]
	     + tri2[0]*tri1[1] + test_point[0]*tri2[1] - tri1[0]*tri2[1]) / denom;

	/* IF INTERSECTION IS BETWEEN VERTICIES 2 AND 3, */
	if ( r >= 0.0 && r <= 1.0 )
	{
	    /* THE POINT IS IN THE TRIANGLE! */
	    found = TRUE;
	}
    }

    /* RETURN SUCCESS STATUS */
    return( found );
}
