
/*
  $Header: /usr2/meuer/Geom_utilities/Poly2tri/RCS/classify.c,v 1.1 91/02/13 09:18:22 meuer Exp $

  Classify each vertex in the polygon as either convex or concave.

  Mark Meuer
  #1267045

  */

#include	"poly2tri.h"

void
classify_verticies( poly )
     Polygon	*poly;
{
    Vertex	*vert;
    Point	side1;
    Point	side2;
    Point	cross_product;
    int		i;
    
    /* FOR EACH VERTEX, */
    vert = poly->top_vertex;
    do
    {
	/* COMPUTE CROSS PRODUCT OF INCIDENT SIDES */
	for ( i = 0; i < POINT_SIZE; i++ )
	{
	    side1[i] = vert->next_vertex->plane_coords[i] - vert->plane_coords[i];
	    side2[i] = vert->prev_vertex->plane_coords[i] - vert->plane_coords[i];
	}
	/*
	  These two lines we obviously don't need since we are just looking at the
	  Z coordinate of the result.
	  cross_product[0] = (side1[1] * side2[2]) - (side1[2] * side2[1]);
	  cross_product[1] = (side1[2] * side2[0]) - (side1[0] * side2[2]);
	  */
	cross_product[2] = (side1[0] * side2[1]) - (side1[1] * side2[0]);
	
	/* IF CROSS PRODUCT POINTS IN POSITIVE Z DIRECTION, */
	if ( cross_product[2] > 0 )
	{
	    /* VERTEX IS CONCAVE */
	    vert->type = CONCAVE;
	}
	/* ELSE */
	else
	{
	    /* VERTEX IS CONVEX */
	    vert->type = CONVEX;
	}
	
	vert = vert->next_vertex;
    }
    while( vert != poly->top_vertex );
}
