
/*
 * $Header: /n/poincare/usr2/meuer/5117/RCS/y_rotation.c,v 1.6 89/05/04
 * 11:37:42 meuer Exp $
 */
/* $Source: /usr2/meuer/Geom_utilities/Matrix_util/RCS/y_rotation.c,v $ */

/*
 * Routine to create a transormation that will rotate points around the y
 * axis.
 *
 * Mark Meuer
 */

#include	"matrix.h"


void
y_rotation_matrix(y_matrix, theta)
Matrix          y_matrix;
Angle           theta;
{
	/* DECLARE VARIABLES */

	/* SET EACH POINT IN THE MATRIX */
	y_matrix[0][0] = (PointElement) cos((double) theta);
	y_matrix[0][1] = 0.0;
	y_matrix[0][2] = (PointElement) -sin((double) theta);
	y_matrix[0][3] = 0.0;

	y_matrix[1][0] = 0.0;
	y_matrix[1][1] = 1.0;
	y_matrix[1][2] = 0.0;
	y_matrix[1][3] = 0.0;

	y_matrix[2][0] = (PointElement) sin((double) theta);
	y_matrix[2][1] = 0.0;
	y_matrix[2][2] = (PointElement) cos((double) theta);
	y_matrix[2][3] = 0.0;

	y_matrix[3][0] = 0.0;
	y_matrix[3][1] = 0.0;
	y_matrix[3][2] = 0.0;
	y_matrix[3][3] = 1.0;
}
