
/*
 * $Header: /n/poincare/usr2/meuer/5117/RCS/shear.c,v 1.1 89/05/09 14:50:51
 * meuer Exp $
 */
/* $Source: /usr2/meuer/Geom_utilities/Matrix_util/RCS/shear.c,v $ */

/*
 * Routine to create a shear matrix.  It will shear around the origin given
 * the PRP, so that the PRP ends up on the z axis.
 *
 * Mark Meuer
 */

#include	"matrix.h"

void
shear_matrix(shear_matrix, prp, center)
Matrix          shear_matrix;
Point           prp;		/* Projection reference point */
Point           center;		/* Center of window */
{
	/* DECLARE VARIABLES */
	char            error_string[ERROR_STRING_LENGTH];
	Point           delta;	/* The difference between the two */
	int             i;

	/* GET THE DIFFERENCE BETWEEN THE TWO POINTS */
	for (i = 0; i < 3; i++)
	{
		delta[i] = prp[i] - center[i];
	}

	debug_point("shear_matrix: prp is", prp);
	debug_point("shear_matrix: center is", center);
	debug_point("shear_matrix: delta is", delta);

	/* IF Z COORD IS ZERO, */
	if (delta[2] == 0.0)
	{
		/* PRINT ERROR */
		sprintf(error_string,
		  "shear_matrix: DELTA has 0 Z coord. DELTA = (%f, %f, %f)",
			(float) delta[0],
			(float) delta[1],
			(float) delta[2]);
		fatal_error(error_string);
	}
	/* ELSE */
	else
	{
		/* FILL THE MATRIX */
		shear_matrix[0][0] = 1.0;
		shear_matrix[0][1] = 0.0;
		shear_matrix[0][2] = 0.0;
		shear_matrix[0][3] = 0.0;

		shear_matrix[1][0] = 0.0;
		shear_matrix[1][1] = 1.0;
		shear_matrix[1][2] = 0.0;
		shear_matrix[1][3] = 0.0;

		shear_matrix[2][0] = -1 * (delta[0] / delta[2]);
		shear_matrix[2][1] = -1 * (delta[1] / delta[2]);
		shear_matrix[2][2] = 1.0;
		shear_matrix[2][3] = 0.0;

		shear_matrix[3][0] = 0.0;
		shear_matrix[3][1] = 0.0;
		shear_matrix[3][2] = 0.0;
		shear_matrix[3][3] = 1.0;
	}
}
