
/*
 * $Header: /n/poincare/usr5/meuer/5117/RCS/cross_prod.c,v 1.1 89/05/02
 * 14:53:56 meuer Exp $
 */
/* $Source: /usr2/meuer/Geom_utilities/Matrix_util/RCS/cross_prod.c,v $ */

/*
 * Routine to produce the cross product of two vectors
 *
 * Mark Meuer
 */

#include	"matrix.h"

void
cross_product(result, a, b)
Vector          result;
Vector          a;
Vector          b;
{
	/* DECLARE VARIABLES */
	char            error_string[ERROR_STRING_LENGTH];
	char            debug_string[DEBUG_STRING_LENGTH];

	/* COMPUTE THE CROSS PRODUCT */

	/*
	 * Note: since the cross product is only defined on 3D vectors, it is
	 * assumed that the vectors are 3D
	 */
	result[0] = (a[1] * b[2]) - (a[2] * b[1]);
	result[1] = (a[2] * b[0]) - (a[0] * b[2]);
	result[2] = (a[0] * b[1]) - (a[1] * b[0]);
}
