
/*
 * $Header: /n/poincare/usr2/meuer/5117/RCS/ang_from_z.c,v 1.1 89/05/04
 * 11:36:39 meuer Exp $
 */
/* $Source: /usr2/meuer/Geom_utilities/Matrix_util/RCS/ang_from_y.c,v $ */

/*
 * Routine to take a vector in the xy plane (z component is zero) and return
 * the angle that the vector must be rotated around Z to get it to line up
 * with the Y axis.
 *
 * Actually, the will probably work for vectors that are not in the xy planes.
 * It will return the angle required to rotate the vector into the yz plane.
 *
 * Mark Meuer
 */
#include	"matrix.h"

Angle
angle_from_y(vector)
Vector          vector;
{
	/* DECLARE VARIABLES */
	Vector          temp_vector;
	Angle           theta;
	double          vector_radius;
	double          xy_radius;	/* length of vector projected onto xy */
	char            error_string[ERROR_STRING_LENGTH];
	char            debug_string[DEBUG_STRING_LENGTH];

	/* GET LENGTH OF VECTOR PROJECTED ONTO XY PLANE */
	copy_vector(temp_vector, vector);
	temp_vector[2] = 0.0;
	xy_radius = (double) vector_norm(temp_vector);
	vector_radius = (double) vector_norm(vector);

	/* MAKE SURE VECTOR IS NOT NULL */
	if (vector_radius == (double) 0.0)
	{
		sprintf(error_string,
			"angle_from_y: NULL rotation vector = (%f, %f, %f)",
			(float) vector[0],
			(float) vector[1],
			(float) vector[2]);
		fatal_error(error_string);
	}
	/* GET ANGLE NEEDED TO SWING VECTOR INTO YZ PLANE */
	/* ONLY DO IT IF NOT IN Z AXIS ALREADY */
	if (xy_radius != (double) 0.0)
	{
		theta = (float) asin((fabs((double) (vector[0]) / xy_radius)));
		sprintf(debug_string,
		   "angle_from_y: before octant corrections: theta = %f,\n",
			(float) theta);
		debug(debug_string);


		/*
		 * THIS ANGLE HAS BEEN FIGURED FOR THE FIRST OCTANTANT.
		 * CORRECT FOR OCTANT IT IS IN.
		 */

		/*
		 * if ((vector[0] < 0.0) && (vector[1] > 0.0)) { theta +=
		 * (Angle) (3.0 * PI / 4.0); debug("angle_from_y: Correcting
		 * for X < 0, Y > 0"); } else if ((vector[0] < 0.0) &&
		 * (vector[1] <= 0.0)) { theta += (Angle) PI;
		 * debug("angle_from_y: Correcting for X < 0, Y <= 0"); }
		 * else if ((vector[0] > 0.0) && (vector[1] <= 0.0)) { theta
		 * += (Angle) (PI / 2.0); debug("angle_from_y: Correcting for
		 * X > 0, Y <= 0"); }
		 */

		/*
		 * if ((vector[1] < 0.0) && (vector[0] < 0.0)) { theta -=
		 * (Angle) (PI/2); } else if ((vector[0] > 0.0) && (vector[1]
		 * < 0.0)) { theta -= (Angle) (3.0 * PI / 2.0); }
		 */

		if (vector[0] <= 0.0)
		{
			if (vector[1] <= 0.0)
			{
				theta = (Angle) ((-1.0 * PI) + theta);
			} else
			{
				theta *= -1.0;
			}
		} else
		{
			if (vector[1] <= 0.0)
			{
				theta = (Angle) ((-1.0 * PI) - theta);
			}
		}



		/*
		 * if ((vector[0] < 0.0) && (vector[1] > 0.0)) { theta *=
		 * -1.0; } else if ((vector[0] < 0.0) && (vector[1] < 0.0)) {
		 * theta = (Angle) ((-1.0 * PI) + theta); } else if
		 * ((vector[0] > 0.0) && (vector[1] < 0.0)) { theta = (Angle)
		 * ((-1.0 * PI) - theta); }
		 */
	}
	/* ELSE, IF VECTOR IS ALREADY IN THE Z AXIS */
	else			/* vector is already Z axis */
	{
		sprintf(error_string,
			"angle_from_y: Vector is in Z axis = (%f, %f, %f)",
			(float) vector[0],
			(float) vector[1],
			(float) vector[2]);
		fatal_error(error_string);
	}

	sprintf(debug_string,
		"angle_from_y: after octant corrections theta = %f\nxy_radius = %f, vector_radius = %f\n",
		(float) theta,
		(float) xy_radius,
		(float) vector_radius);
	debug(debug_string);

	/* RETURN VALUES TO USER */
	return (theta);
}
