
/*
  $Header: /usr2/meuer/Geom_utilities/Arc2list/RCS/arcstuff.c,v 1.1 91/02/05 15:10:48 meuer Exp $

  Different routines for dealing with arcs.

  Toby Orloff
  very slightly modified by Mark Meuer

  */

#include	"breakarc.h"
#include	"mf.h"

DivideArc(pnt1,pnt2,num,arc)

double pnt1[3],pnt2[3],*arc;
int num;

/* Routine divides arc centered at origin into num line segments */
/* Result goes in arc, which is assumed to hold enough space */

{
  double angle,temp,theta;
  double coeff,A,B,x,y;   /* coefficients of linear system */
  double cs1,cs2,denom;
  int i;

  coeff = DotProduct(pnt1,pnt2)/DotProduct(pnt2,pnt2);
  temp = 1.0 - coeff*coeff;
  if(temp < EPSILON) {
     for(i=0;i<3*num;i+=3) {
        arc[i] = pnt1[0]; arc[i+1] = pnt1[1]; arc[i+2] = pnt1[2];
       }
     arc[3*num] = pnt2[0]; arc[3*num+1] = pnt2[1]; arc[3*num+2] = pnt2[2];
     return(1);
    }

  denom = 1.0/temp;

  theta = Angle(pnt1,pnt2);
  arc[0] = pnt1[0]; arc[1] = pnt1[1]; arc[2] = pnt1[2];
  angle = 0.0;
  for(i=1;i<num;++i) {
     angle += theta/(double) num;;
     cs1 = cos(angle); cs2 = cos(theta-angle);
     y = (cs2 - cs1*coeff)*denom;
     x = (cs1 - cs2*coeff)*denom;
     
     arc[3*i] = x*pnt1[0] + y*pnt2[0];
     arc[3*i+1] = x*pnt1[1] + y*pnt2[1];
     arc[3*i+2] = x*pnt1[2] + y*pnt2[2];
    }
  arc[3*num] = pnt2[0]; arc[3*num+1] = pnt2[1]; arc[3*num+2] = pnt2[2];
  return(1);   
}



double ArcLength(pnt1,pnt2)

double pnt1[3],pnt2[3];
{
  double r_squared;
 
  r_squared = pnt1[0]*pnt1[0] + pnt1[1]*pnt1[1] + pnt1[2]*pnt1[2];
  return(sqrt(r_squared) * acos(DotProduct(pnt1,pnt2)/r_squared));

}
