/*************************************************************
*  This file is part of the Surface Evolver source code.     *
*  Programmer:  Ken Brakke, brakke@geom.umn.edu              *
*************************************************************/


/********************************************************************
*
*  File: storeseg.h
*
*  Purpose:  Header file defining details of storage implementation.
*            All machine-dependent gory details should be here
*            (for inclusion in other source files that need to know)
*            or in storage.c (purely private details).
*
*     This version has element ids typed as longs,
*     and segmented storage for DOS.
*     Elements are grouped into blocks for fitting in segments.
*     For use in MS-DOS or XENIX-286.
*/

#define NUMELEMENTS 5

/* these values used for identification and as index into skeleton info */
#define  VERTEX  0
#define  EDGE    1
#define  FACET   2
#define  BODY    3
#define  FACETEDGE    4 

/*****************************************************************
*
*  Universal element identifier
*
*/
/*
/*typedef struct xelement_id {
/*    unsigned int  type : 6;   /* see enum below */
/*    unsigned int  valid: 1;   /* valid id bit */
/*    unsigned int  sign : 1;   /* set for reverse orientation */
/*    unsigned int  offset: 24;   /* offset from block start */
/*    } xelement_id;
 */

/* masks for fields */
#define TYPEMASK   0xFC000000
#define VALIDMASK  0x02000000
#define SIGNMASK   0x01000000
#define BLOCKMASK  0x00FF0000
#define OFFSETMASK 0x0000FFFF

/* shifts for fields */
#define TYPESHIFT  26
#define VALIDSHIFT 25
#define SIGNSHIFT  24
#define BLOCKSHIFT 16

/* to get type of an element */
#define id_type(id)  ((int)(((id)&TYPEMASK)>>TYPESHIFT))

#define NULLID 0L

/* to give switched orientation of first if that of second is inverted */
#define same_sign(id1,id2)    ((id1) ^ ((id2) & SIGNMASK))

/* number of elements to allocate memory for at one time */
#define BATCHSIZE 100

/* outside storage.*, element_id structure is not visible; acts like long */    
typedef long
     element_id, vertex_id, edge_id, facet_id, body_id, facetedge_id; 

/* macros for getting structure pointer from id */
#define addr(b,id) (b[((id)&BLOCKMASK)>>BLOCKSHIFT] + ((id)&OFFSETMASK))
#define vptr(v_id) ((struct vertex *)(addr(vbase,v_id)))
#define eptr(e_id) ((struct edge   *)(addr(ebase,e_id)))
#define fptr(f_id) ((struct facet  *)(addr(fbase,f_id)))
#define bptr(b_id) ((struct body   *)(addr(bbase,b_id)))
#define feptr(fe_id) ((struct facetedge *)(addr(febase,fe_id)))

/* id attr bits */
#define VALID_BIT   0x0001
#define INVERSE_BIT 0x0001

#define edge_inverse(id)  inverse_id(id)
#define facet_inverse(id)  inverse_id(id)
#define fe_inverse(id)  inverse_id(id)
#define invert(id)     ((id) ^= SIGNMASK)
#define equal_id(a,b)  ((a)==(b))
#define equal_element(a,b)  (((a)|SIGNMASK) == ((b)|SIGNMASK))
#define valid_id(id)   ((id)&VALIDMASK)
#define inverted(id)   ((id)&SIGNMASK)
#define inverse_id(id) ((id) ^ SIGNMASK)

#define MAXBLOCK 255
typedef int ORDTYPE;                /* element numbering type */

/* base structure for a skeleton of a particular dimension */
struct skeleton {
    int             type;   /* type of element, see defines above */
    char           **base;   /* to list of structures     */
    int             blocks;   /* number of blocks allocated */
    long            maxcount; /* elements allocated          */
    element_id      free;   /* start of free list        */
    element_id      used;   /* start of in-use elements  */
    element_id      last;   /* end of in-use chain, for adding on */
    element_id      discard; /* start of discard list */
    long            count;  /* number active             */
    element_id      current; /* current element in generation */
    ORDTYPE         max_ord; /* highest ordinal */
  } ;

/* individual dimension block pointer arrays, handy for debugging */
extern char **vbase;
extern char **ebase;
extern char **fbase;
extern char **bbase;
extern char **febase;

/* unified block references, indexed by element type */
extern char **base[NUMELEMENTS];
