/*************************************************************
*  This file is part of the Surface Evolver source code.     *
*  Programmer:  Ken Brakke, brakke@geom.umn.edu              *
*************************************************************/

/*************************************************************
*
*  File:  proto.h
*
*  Purpose: ANSI function prototypes.
*/

void set_f_phase_density(facet_id);
void set_e_phase_density(edge_id);
int bdry_basis(vertex_id,REAL**);
int constr_basis(vertex_id,REAL**);
void  sp_order(int,int*,int*,int*,int*);
int  sp_fill_setup(int,int*,int*,int*,int*,int*);
void  sp_factor(int,int*,int*,int*,int*,int*,double*,double*);
void  sp_backsub(int,int*,int*,int*,double*,double*,double*);
void stability_test(void);
void mobility_cleanup(void);
void mobility_mult(double*);
void mobility_setup(void);
void approx_curv_calc(void);
void approx_curvature(void);
int new_popverst(vertex_id,int);
void phase_initialize(char *);
void check_vertex_fe(vertex_id);
void information(void);
void show_volumes(void);
void set_parameters(void);
int minus_type(void);
void string_fixup(void);
char *kb_realloc(char*,int);
void runge_kutta(void);
void autopop_pop(void);
void autochop_chop(void);
void autopop_detect(REAL);
vertex_id find_other_vertex(vertex_id *,int,vertex_id);
void simplex_delauney_test(void);
void push_face(vertex_id *);
int pop_face(vertex_id *);
void end_face_stack(void);
void init_face_stack(int);
void simplex_equiangulate(void);
void calc_simplex_edge_force(edge_id);
int kernel_basis(REAL**,REAL**,int,int);
void tr_mat_mul(REAL**,REAL**,REAL**,int,int,int);
void mat_mul_tr(REAL**,REAL**,REAL**,int,int,int);
void calc_simplex_edge_energy(edge_id);
void exterior_product(REAL **,REAL *,int,int);
int binom_coeff(int,int);
void hi_dim_graph(void);
void recalc(void);
void kusner_energy(void);
void kusner_force(void);
void sqgauss_energy(void);
void prompt(char*,char*);
void NeXT_display(void);
void update_display(void);
void set_spinr(REAL);
void set_spinl(REAL);
void set_tipup(REAL);
void set_tipdown(REAL);
void set_clockwise(REAL);
void set_counterclockwise(REAL);
void skinny_histogram(void);
int skinny(REAL);
int get_edge_valence(edge_id);
void alice(void);
void sqcurve_force_string(vertex_id);
void sqcurve_force_string_end(void);
void sqcurve_energy_string(vertex_id);
void bad_function(void);
void sqcurve_force_init(void);
void sqcurve_energy_init(void);
void sqcurve_energy(vertex_id*, REAL (*)[MAXCOORD]); 
void sqcurve_force(vertex_id*,edge_id*,REAL(*)[MAXCOORD]); 
void sqcurve_energy_end(void);
void sqcurve_force_end(void);
void top_dump(FILE *);
void vertex_dump(vertex_id,FILE *);
void edge_dump(edge_id,FILE *);
void facet_dump(facet_id,FILE *);
void facetedge_dump(facetedge_id,FILE *);
void body_dump(body_id,FILE *);
WRAPTYPE torus_inverse(WRAPTYPE);
WRAPTYPE torus_compose(WRAPTYPE,WRAPTYPE);
void torus_wrap(REAL *,REAL *,WRAPTYPE);
void torus_form_pullback(REAL *,REAL *,REAL *,WRAPTYPE);
WRAPTYPE group_inverse(WRAPTYPE);
WRAPTYPE group_compose(WRAPTYPE,WRAPTYPE);
void group_wrap(REAL *,REAL *,WRAPTYPE);
void group_form_pullback(REAL *,REAL *,REAL *,WRAPTYPE);
void print_matrix( REAL **, int , int );
double simplex_energy_metric(vertex_id*,REAL * *);
void simplex_force_metric(vertex_id *,REAL**, REAL,REAL **);
void gauss_setup(void);
void simplex_grad_l(void);
void end_hash_table(void);
void rehash(void);
void init_hash_table(void);
void check_orientation(void);
void refine_simplex_init(void);
void refine_all_simplices(void);
int poponest(struct veredge *,int);
void free_discards(void);
int find_vertex_to_pop(void);
void puff(void);
double splinepoly(int,double);
double splinederiv(int,double);
void spline_partial(int *,double,int,REAL *);
void spline_partial_t(int *,double,REAL *);
void dump_buff(void);
int  command(char *);
void newcommand(char *);
void new_history(char *);
void old_history(char *);
void refine_query(void);
void set_query(void);
void delete_query(void);
void list_query(void);
int  qqparse(void);
char *mycalloc(int,int);
char *temp_calloc(int,int);
void temp_free(char *);
void temp_free_all(void);
void cg_direction(void);
void cg_calc_gamma(void);
void simplex_facet_average(facet_id);
void facet_average(facet_id);
void edge_average(edge_id);
void recalc_verts(void);
void grule(int , double *, double *);
void read_facet_edges(void);
void read_faces(void);
void read_edges(void);
void read_vertices(void);
void read_bodies(void);
void read_quantity(void);
int read_const(REAL *);
void lowbound(void);
void ridge_histogram(void);
int collapse_check(void);
#ifndef TCPP
int vvvvcomp(struct vvvv *,struct vvvv *);
#endif
void End_OOGL(void );
void UpdateOOGL(void );
void Begin_OOGL(void );
void softimage(void );
void constraint_init(struct constraint *);
void constraint_free(struct constraint *);
void convert_all_expr(void);
void expr_convert(struct expnode *);

REAL find_flux(facet_id);
int is_constant(int);
void free_expr(struct expnode *);
void startup(char *);
void reset_view(void);
void read_parameter(void);
void zoom_vertex(vertex_id,REAL);
REAL distance(vertex_id,vertex_id);
void merge_collapsed_facets();
void constr_vol_grad_q(edge_id);
void homothety(void);
void ex_fold(struct treenode *);
void fold_recur(struct treenode *, int *);
int yybegin(void);
void yylex_init(void);
int yyerror(char *);
int yyparse(void);
int  yylook(void);
int  yywrap(void);
int yylex(void);
int gettok(int);
int  input(void);
void unput(int);
int  macro(void);
void record_macro(void);
void fe_reorder(void);
void pix_start(void);
void pix_facet(struct graphdata *,facet_id);
void pix_end(void);
void constr_edge_force_q(edge_id);
void move_vertex(vertex_id);
void restore_vertex(vertex_id);
REAL normal_change_check(void);
FILE *path_open(char *);
void fil_finish(void);
void fil_facet(struct tsort *);
void fil_edge(struct tsort *);
void fil_init(void);
void ps_finish(void);
void ps_facet(struct tsort *);
void ps_edge(struct tsort *);
void ps_init(void);
void display_file(void);
void graph_help(void);
void main_help(void);
REAL edge_grav_density(edge_id);
int facet_body_check(void);
int facetedge_check(int);
int list_check(void);
int run_checks(void);
/*global*/  void pop_vertex(vertex_id,int);
int popfilm(void);
void face_triangulate(facet_id,int);
void file_wulff(REAL *,REAL *);
void lens_wulff(REAL *,REAL *);
void hemi_wulff(REAL *,REAL *);
int curtest_facet(facet_id);
int curtest_edge(edge_id,facetedge_id,facetedge_id);
void curtest(void);
void fix_volconst(void);
element_id upgrade(element_id);
facet_id dup_facet(facet_id);
body_id dup_body(body_id);
double estimate_decrease(void);
void constr_edge_content_q(edge_id);
void constr_edge_energy_q(edge_id);
void tordup(int);
void add_outside(void);
void calc_content(void);
int equal_constr(element_id ,element_id) ;
void      bdry_spring_energy(edge_id);
void      constr_spring_energy(edge_id);
int boundary_pull_film(void);
void torus_cells(void);
void torus_edge_clip(struct graphdata *,int );           
void null_function(void);
void diffuse(void);
int cone_analyze(struct verfacet *,int);
vertex_id dup_vertex(vertex_id);
edge_id dup_edge(edge_id);
void versplit(facetedge_id ,facetedge_id) ;
int try_prop(facetedge_id *);
int edgepop_film(void);
void print_express(struct expnode *,char *,int,int);
void exprint_recur(struct treenode *,int);
char *kb_strstr(char *,char *);
void kb_memmove(char *,char *,int);
int pixdump(void);
void constr_springs(edge_id);
void save_coords(void);
void restore_coords(void);
void unsave_coords(void);
void enforce_constraints(void);
void kb_strupr(char *);
/*global*/  void b_proj(struct boundary *,REAL *,REAL * *,int );
/*global*/  void b_extrapolate(struct boundary *,REAL *,REAL *,REAL *,REAL *,REAL *);
/*global*/  void bdry_force(long );
/*global*/  void calc_bdry_force_v(long );
/*global*/  void calc_bdry_force_e(long );
/*global*/  void calc_bdry_energy_v(long );
/*global*/  void calc_bdry_energy_e(long );
/*global*/  void calc_bdry_content_v(long );
/*global*/  void calc_bdry_content_e(long );
/*global*/  void calc_force(void );
/*global*/  void calc_energy(void);
/*global*/  void calc_pressure(void );
/*global*/  void reset_mode(void );
/*global*/  void cgigraph_edge(struct tsort *);
/*global*/  void cgigraph_facet(struct tsort *);
/*global*/  void close_graphics(void );
/*global*/  void display(void );
/*global*/  int constr_proj(int ,int ,struct constraint * *,REAL *,REAL *,REAL *,int *,int);
/*global*/  void project_v_constr(long );
/*global*/  void calc_constr_force_v(long );
/*global*/  void calc_constr_force_e(long );
/*global*/  void calc_constr_energy_v(long );
/*global*/  void calc_constr_energy_e(long );
/*global*/  void calc_constr_content_v(long );
/*global*/  void calc_constr_content_e(long );
/*global*/  void dump(void );
/*global*/  void do_dump(char *);
/*global*/  REAL eval(struct expnode *,REAL *);
/*global*/  void eval_all( struct expnode *, REAL *, int, REAL *, REAL *);
/*global*/  REAL tree_eval(struct treenode *,REAL *);
/*global*/  REAL eval_deriv(struct expnode *,REAL *,int );
/*global*/  REAL tree_eval_deriv(struct treenode *,REAL *,int );
/*global*/  int exparse(int ,struct treenode * *);
/*global*/  void calc_simplex_forces(facet_id);
/*global*/  void calc_simplex_energy(facet_id);
/*global*/  void calc_simplex_volume(facet_id);
/*global*/  void facet_force_l(long );
/*global*/  void facet_energy_l(long);
/*global*/  void facet_force_l_hi_d(long );
/*global*/  void facet_energy_l_hi_d(long);
/*global*/  void facet_volume_l(long );
/*global*/  void film_grad_l(void );
/*global*/  void film_bdry_grad(void );
/*global*/  void film_constr_grad(void );
/*global*/  void facet_force_q(long );
/*global*/  void facet_energy_q(long );
/*global*/  void facet_volume_q(long );
/*global*/  void film_grad_q(void );
/*global*/  REAL tq7_integral(REAL (*)(REAL,REAL));
/*global*/  REAL intpoly6(int ,REAL ,REAL );
/*global*/  REAL intpoly6part(int ,int ,REAL ,REAL );
/*global*/  REAL vintzf(REAL ,REAL );
/*global*/  void vcoeff_init(void );
/*global*/  void vol_project(int );
/*global*/  int graphgen(void );
/*global*/  void plain_facets(void );
/*global*/  void plain_edges(void );
/*global*/  void bare_edges(void );
/*global*/  void triple_edges(void );
/*global*/  void torus_clip(struct graphdata *,int );
/*global*/  int bfcomp(struct bodyface *,struct bodyface *);
/*global*/  void torus_bodies(void );
/*global*/  void reset_web(void );
/*global*/  void initialize(void);
/*global*/  void read_periods(void );
/*global*/  void wulff_initialize(char *);
/*global*/  void read_boundary(void);
/*global*/  void read_constraint(void);
/*global*/  void read_surface_energy(void);
/*global*/  void iterate(void );
/*global*/  void fix_vertices(void );
/*global*/  void move_vertices(void );
/*global*/  void jiggle(void );
/*global*/  void long_jiggle(void );
/*global*/  REAL gaussian(void );
/*global*/  void nrerror(char *);
/*global*/  void matcopy(REAL * *,REAL * *,int ,int );
/*global*/  REAL * *dmatrix(int ,int ,int ,int );
/*global*/  REAL * * * dmatrix3(int ,int ,int );
/*global*/  int *ivector(int ,int );
/*global*/  REAL *vector(int ,int );
/*global*/  void free_ivector(int *,int ,int );
/*global*/  void free_vector(REAL *,int ,int );
/*global*/  void free_matrix(REAL * *);
/*global*/  void free_matrix3(REAL * * *);
/*global*/  void vnormal(REAL *,REAL *,REAL *,REAL *);
/*global*/  void cross_prod(REAL *,REAL *,REAL *);
/*global*/  REAL triple_prod(REAL *,REAL *,REAL *);
/*global*/  REAL dot(REAL *,REAL *,int );
/*global*/  REAL dotf(float *,float *,int );
/*global*/  void matvec_mul(REAL * *,REAL *,REAL *,int ,int );
/*global*/  void vec_mat_mul(REAL *,REAL ** ,REAL *,int ,int );
/*global*/  void mat_mult(REAL * *,REAL * *,REAL * *,int ,int ,int );
/*global*/  double quadratic_form(REAL *,REAL **,REAL *,int);
/*global*/  int  mat_inv(REAL * *,int );
/*global*/  double  determinant(REAL * *,int );
/*global*/  double  det_adjoint(REAL * *,int );
/*global*/  void change_model(void );
/*global*/  void linear_to_quad(void );
/*global*/  void quad_to_linear(void );
/*global*/  void edge_divide(long );
/*global*/  void cross_cut(long ,long );
/*global*/  void display(void);
/*global*/  void painter_start(void );
/*global*/  void painter_facet(struct graphdata *,long );
/*global*/  void painter_end(void );
/*global*/  int in_back(struct tsort *,struct tsort *);
/*global*/  void pivot(int ,int ,int );
/*global*/  void painter_edge(struct graphdata *);
/*global*/  int verpop_film(void );
/*global*/  void do_save(void );
/*global*/  void do_restore(void );
/*global*/  void set_fe_edge(long ,long );
/*global*/  void set_fe_facet(long ,long );
/*global*/  long get_fe_facet(long );
/*global*/  long get_prev_facet(long );
/*global*/  long get_next_facet(long );
/*global*/  void set_prev_edge(long ,long );
/*global*/  void set_next_edge(long ,long );
/*global*/  void set_prev_facet(long ,long );
/*global*/  void set_next_facet(long ,long );
/*global*/  void set_edge_wrap(long ,WRAPTYPE  );
/*global*/  WRAPTYPE get_edge_wrap(long );
/*global*/  void set_edge_fe(long ,long );
/*global*/  long get_edge_fe(long );
/*global*/  void set_edge_tailv(long ,long );
/*global*/  void set_edge_headv(long ,long );
/*global*/  long get_facet_body(long );
/*global*/  void set_facet_body(long ,long );
/*global*/  long get_facet_fe(long );
/*global*/  void set_facet_fe(long ,long );
/*global*/  long new_vertex(REAL *);
/*global*/  long new_edge(long ,long );
/*global*/  long new_facet(void );
/*global*/  long new_body(void );
/*global*/  long new_facetedge(long ,long );
/*global*/  REAL get_edge_length(long );
/*global*/  REAL get_facet_pressure(long );
/*global*/  void generate_facet_fe_init(void );
/*global*/  int generate_facet_fe(long ,long *);
/*global*/  void generate_edge_fe_init(void );
/*global*/  int generate_edge_fe(long ,long *);
#ifndef elptr
/*global*/  struct element *elptr(element_id );
#endif
/*global*/  void extend(int,int );
/*global*/  long new_element(int );
/*global*/  void free_element(long );
/*global*/  int ordinal(long );
/*global*/  int generate_all(int ,long *);
/*global*/  void memory_report(void );
/*global*/  void reset_skeleton(void );
/*global*/  void vgrad_init(int );
/*global*/  void vgrad_end(void );
/*global*/  struct volgrad *get_vertex_vgrad(vertex_id);
/*global*/  struct volgrad *get_next_vgrad(struct volgrad *);
/*global*/  struct volgrad huge *new_vgrad(void );
/*global*/  struct volgrad *get_bv_vgrad(long ,long );
/*global*/  struct volgrad *get_bv_new_vgrad(long ,long );
/*global*/  long new_element(int );
/*global*/  void free_element(long );
/*global*/  int generate_all(int ,long *);
/*global*/  void memory_report(void );
/*global*/  void reset_skeleton(void );
/*global*/  void edge_force_l(long );
/*global*/  void edge_energy_l(long );
/*global*/  void edge_area_l(long );
/*global*/  void edge_force_l_metric(long );
/*global*/  void edge_energy_l_metric(long );
/*global*/  void edge_force_q_metric(long );
/*global*/  void edge_energy_q_metric(long );
/*global*/  void string_grad_l(void );
/*global*/  void string_bdry_grad(void );
/*global*/  void string_constr_grad(void );
/*global*/  REAL interpoly(int ,REAL );
/*global*/  REAL interpolyderiv(int ,REAL );
/*global*/  void scoeff_init(void );
/*global*/  void edge_force_q(long );
/*global*/  void edge_energy_q(long );
/*global*/  void edge_area_q(long );
/*global*/  void string_grad_q(void );
/*global*/  void torshow(void );
/*global*/  int  view_transform(char *);
/*global*/  void init_view(void );
/*global*/  void resize(void );
/*global*/  void old_menu(char * );
/*global*/  void extrapolate(void );
/*global*/  void save(void );
/*global*/  void restore(char *);
/*global*/  void torvol(void);
/*global*/  void torvol_project(int  );
/*global*/  void refine(void );
/*global*/  int areaweed(REAL );
/*global*/  void area_histogram(void );
/*global*/  int edgeweed(REAL );
/*global*/  void edge_histogram(void );
/*global*/  int eliminate_edge(long );
/*global*/  void change_vertex(long ,long ,long ,WRAPTYPE);
/*global*/  int articulate(REAL );
/*global*/  int edge_refine(long );
/*global*/  int equiangulate(void );
/*global*/  int ridge_notcher(REAL );
/*global*/  void outstring(char *);
/*global*/  void getstring(char *);
/*global*/  void error(char *,int );
/*global*/  void catcher(int );
/*global*/  void calc_edge(long );
/*global*/  void get_edge_side(long ,REAL *);
/*global*/  void get_adjust(long ,REAL *);
/*global*/  void get_edge_adjust(long ,REAL *);
/*global*/  void calc_vertex_normal(long ,REAL *);
/*global*/  void get_facet_verts(long ,REAL * *,WRAPTYPE*);
/*global*/  int verpop_str(void );
void dump_force(void);
void vertex_average(int);
void global_adjust(int);

#ifdef NeXT
/*global*/  void set_attr(long ,int );
/*global*/  void unset_attr(long ,int );
int makenode(int,int,int);
#else
/*global*/  void set_attr(long ,ATTR );
/*global*/  void unset_attr(long ,ATTR );
int makenode(NTYPE,NTYPE,NTYPE);
#endif

#ifdef XXXX
/* some functions replaced by macros */
/*global*/  long get_prev_edge(long );
edge_id get_fe_edge(facetedge_id);
/*global*/  long get_next_edge(long );
/*global*/  long get_edge_tailv(long );
/*global*/  long get_edge_headv(long );
#endif

