/**********************************************************************
*
*  File: model.h
*
*  Header file for evolver.  Defines model parameters.
*
*/

/* maximum dimensionality */
#define MAXCOORD 4
#define MAXCTRL 6
#define MAXPARAM 2
#define MAXCONSTR 4
#define MAXWDIM 2
#define FACET_VERTS 3
#define FACET_EDGES 3

/* model types */
#define LINEAR    1
#define QUADRATIC 2

/* Quadratic model point counts */
/* Control points per edge */
#define EDGE_CTRL  3
/* Control points per facet */
#define FACET_CTRL 6
/* Integration points per edge */
#define EDGE_INTERP  3
/* Integration points per facet */
#define FACET_INTERP 7

/* quadratic interpolation coefficients */
/* partials of interpolation polynomials at midpoints of patch edges */
/* control points are numbered 0 to 5 counterclockwise */
/* midpoints are numbered 0 to 2 counterclockwise after control pt 0 */
/* dip[midpoint][control point][partial]  */

extern REAL dip[3][FACET_CTRL][2];

/* Histogram size */
#define HISTO_BINS 40 
#define HISTO_BINSIZE (1/M_LN2)
