(* This program is by Adrian Mariano: adrian@u.washington.edu
 *
 * Copyright (c) 1991, The Geometry Center
 *                     University of Minnesota 
 *                     1300 South Second Street
 *                     Minneapolis, MN  55454
 *
 * email address: software@geom.umn.edu
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 *     The National Science and Technology Research Center for
 *      Computation and Visualization of Geometric Structures
 *)

ParallelSurfacesFile::usage=
"ParallelSurfacesFile[{fx,fy,fz}, {u, umin, umax, ucount}, 
	{v, vmin, vmax, vcount}, {tmin, tmax, tcount}, name]
	Produces a C header file defs.h which defines bounds,
	and functions for generating the parallel surfaces
	to the specified surface.  The variable name is a string
	variable which is used as the suffix by the C program
	for the data files it produces."

ParallelSurfacesFile[func:{_, _, _}, {uvar_, umin_, umax_, ucount_},
    {vvar_, vmin_, vmax_, vcount_}, {tmin_, tmax_, tcount_}, name_] :=
   Block[{a = 0, v, u}, f[u_, v_] :=
      Release[func /. {uvar -> N[u], vvar -> N[v]}];
     dfu[u_, v_] := Release[D[f[u, v], u]];
     dfv[u_, v_] := Release[D[f[u, v], v]];
     cross[u_List, v_List] := RotateLeft[u*RotateLeft[v] - RotateLeft[u]*v];
     n[u_, v_] := cross[dfu[u, v], dfv[u, v]];
     norm[u_, v_] := (temp = n[u, v]; temp/Sqrt[temp . temp]);
     F[u_, v_, t_] := f[u, v] + t*norm[u, v]; num = 0;
    fname=OpenWrite["defs.h",FormatType->CForm];
    WriteString[fname,"#define TMIN ", ToString[tmin//N], "\n"];
    WriteString[fname,"#define TSTEP ", ToString[(tmax-tmin)/(tcount-1)//N], "\n"];
    WriteString[fname,"#define TCOUNT ", ToString[tcount], "\n"];
    WriteString[fname,"#define UMIN ", ToString[umin//N], "\n"];
    WriteString[fname,"#define USTEP ", ToString[(umax-umin)/(ucount)//N], "\n"];
    WriteString[fname,"#define UCOUNT ", ToString[ucount+1], "\n"];
    WriteString[fname,"#define VMIN ", ToString[vmin//N], "\n"];
    WriteString[fname,"#define VSTEP ", ToString[(vmax-vmin)/vcount//N], "\n"];
    WriteString[fname,"#define VCOUNT ", ToString[vcount+1], "\n"];
    WriteString[fname,"#define NAME \"", ToString[name//N], "\"\n"];
    WriteString[fname,"#define F1(u, v, t) ", CForm[F[u,v,t][[1]]], "\n"];
    WriteString[fname,"#define F2(u, v, t) ", CForm[F[u,v,t][[2]]], "\n"];
    WriteString[fname,"#define F3(u, v, t) ", CForm[F[u,v,t][[3]]], "\n"];
    Close[fname];
]


 
