(* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of CirclePack. CirclePack is free software; you can
redistribute it and/or modify it only under the terms given in the
file COPYING, which you should have received along with this file.
This and other software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. *)

(* Author: Silvio Levy *)
(* $Id: Normalize.m,v 1.2 1992/07/17 16:09:52 oag Exp $ *)
(* NOTE: This package is under development as part of a separate 
   hyperbolic geometry package. *)

BeginPackage["Normalize`"]

Normalize::usage = "
   Normalize[x] returns a unit vector parallel to x,\n
   which should have head List.  If x=0 it returns Null.\n
   Normalize[x,r] returns a vector of length r parallel to x."

Begin["`private`"]

Normalize::zero = "Cannot normalize ``"

Normalize[x_List] := Message[Normalize::zero,Null] /; x.x==0
Normalize[x_List] := x/Sqrt[x.x]
Normalize[x_List,r_] := r Normalize[x]

End[]
EndPackage[]
