#include <stdio.h>

struct vertex3 { double x,y,z ; } *vertices;
int  nel ;
char *malloc();
char *realloc();

main(argc,argv)
int argc;
char **argv;
{
	int comp(),ncomp();
	int i;
	int comp_sense = 0;
	int tests = 0;
	int debug = 0;
	int nsize = 1;

	for (i = 1 ; i < argc ; i++ )	
		switch(argv[i][0])	{
			case 't' : tests = atoi(&argv[i][1]); break;
			case 'n' : nsize = atoi(&argv[i][1]); break;
			case 'd' : debug = 1; break;
			case 'c' : comp_sense = 1; break;
			default : fprintf(stderr,"cases are tdc\n"); exit(1);
			}

	get_vertices();

	if (tests > 0)	{
		maximize(vertices  ,nel  , 1.0, 0.0, 0.0);
		maximize(vertices+1,nel-1,-1.0, 0.0, 0.0);
		maximize(vertices+2,nel-2, 0.0, 1.0, 0.0);
		maximize(vertices+3,nel-3, 0.0,-1.0, 0.0);
		maximize(vertices+4,nel-4, 0.0, 0.0, 1.0);
		maximize(vertices+5,nel-5, 0.0, 0.0,-1.0);
		nsize = 6;
		}

	if (tests > 1)	{
		maximize(vertices+6 ,nel-6 , 1.0, 1.0, 0.0);
		maximize(vertices+7 ,nel-7 , 1.0,-1.0, 0.0);
		maximize(vertices+8 ,nel-8 ,-1.0, 1.0, 0.0);
		maximize(vertices+9 ,nel-9 ,-1.0,-1.0, 0.0);
		maximize(vertices+10,nel-10, 0.0, 1.0, 1.0);
		maximize(vertices+11,nel-11, 0.0, 1.0,-1.0);
		maximize(vertices+12,nel-12, 0.0,-1.0, 1.0);
		maximize(vertices+13,nel-13, 0.0,-1.0,-1.0);
		maximize(vertices+14,nel-14, 1.0, 0.0, 1.0);
		maximize(vertices+15,nel-15, 1.0, 0.0,-1.0);
		maximize(vertices+16,nel-16,-1.0, 0.0, 1.0);
		maximize(vertices+17,nel-17,-1.0, 0.0,-1.0);
		nsize = 18 ;
		}

	if (tests > 2)	{
		maximize(vertices+18,nel-18,-1.0,-1.0,-1.0);
		maximize(vertices+19,nel-19,-1.0,-1.0, 1.0);
		maximize(vertices+20,nel-20,-1.0, 1.0,-1.0);
		maximize(vertices+21,nel-21,-1.0, 1.0, 1.0);
		maximize(vertices+22,nel-22, 1.0,-1.0,-1.0);
		maximize(vertices+23,nel-23, 1.0,-1.0, 1.0);
		maximize(vertices+24,nel-24, 1.0, 1.0,-1.0);
		maximize(vertices+25,nel-25, 1.0, 1.0, 1.0);
		nsize = 26 ;
		}


	if (debug) print_vertices(nel,debug);
	if (comp_sense)
		qsort(vertices + nsize, nel - nsize, sizeof(struct vertex3), ncomp);
	else
		qsort(vertices + nsize, nel - nsize, sizeof(struct vertex3), comp);
	print_vertices(nsize,debug);
}
  
struct vertex3 cm;
#define SQ(x) ((x) * (x))

comp(u,v)
struct vertex3 *u, *v ;
{
	double d1, d2;
	d1 = SQ(cm.x - u->x) + SQ(cm.y - u->y) + SQ(cm.z - u->z) ; 
	d2 = SQ(cm.x - v->x) + SQ(cm.y - v->y) + SQ(cm.z - v->z) ; 
	if (d1 > d2) return(-1);
	if (d1 < d2) return(1);
	return(0);
}

ncomp(u,v)
struct vertex3 *u, *v ;
{
	double d1, d2;
	d1 = SQ(cm.x - u->x) + SQ(cm.y - u->y) + SQ(cm.z - u->z) ; 
	d2 = SQ(cm.x - v->x) + SQ(cm.y - v->y) + SQ(cm.z - v->z) ; 
	if (d1 > d2) return(1);
	if (d1 < d2) return(-1);
	return(0);
}

maximize(vf, nelems, dx, dy, dz )
struct vertex3 *vf;
int nelems;
double dx,dy,dz;
{
	int i,imax;
	struct vertex3 *v;
	double vmax, tval, dot;

	vmax = -1000000.0 ; imax = -1;

	for (i = 0, v = vf ; i < nelems; i++ , v++ ) {
		dot = v->x*dx + v->y*dy + v->z*dz ;
		if (dot > vmax) { imax = i ; vmax = dot ; }
		}

	if (imax == 0) return ;

	tval = (vf+imax)->x ; (vf+imax)->x = vf->x ; vf->x = tval ;
	tval = (vf+imax)->y ; (vf+imax)->y = vf->y ; vf->y = tval ;
	tval = (vf+imax)->z ; (vf+imax)->z = vf->z ; vf->z = tval ;
}

get_vertices()
{

	struct vertex3 *v;
	double x, y, z;
	int i, done = 0 ;

#define CHUNK 1000
	vertices = (struct vertex3 *) malloc(CHUNK * sizeof(struct vertex3));
	nel = 0;
	
	while (!done)	{
		for (i = 0 ; i < CHUNK ; nel++, i++ ) {
			if  (scanf("%lf%lf%lf", &x, &y, &z ) == -1 )  { done = 1; break; }
			vertices[nel].x = x;
			vertices[nel].y = y;
			vertices[nel].z = z;
       	         }
		 if (!done) vertices = (struct vertex3 *) 
			realloc(vertices, (nel + CHUNK) * sizeof(struct vertex3) );
		}
	
	cm.x = cm.y = cm.z = 0.0;
	v = vertices ;
	for (i = 0 , v = vertices ; i < nel ; i++ , v++  ) {
                cm.x += v->x/nel; cm.y += v->y/nel; cm.z += v->z/nel;
		}
}

print_vertices(nn,debug)
int nn,debug;
{	int i ;
	double *d;

	if (debug) 	{
		d = (double *) malloc(nel * sizeof (double));
		for (i = 0  ; i < nel ; i++ )
			d[i] = SQ(vertices[i].x - cm.x) +  SQ(vertices[i].y - cm.y)
			 +  SQ(vertices[i].z - cm.z) ;
		}
		
	for (i = 0  ; i < nn ; i++ )
		if (!debug)
       			printf("%g %g %g\n",vertices[i].x,vertices[i].y,vertices[i].z);
		else	 
       			printf("%g %g %g %g\n",vertices[i].x,vertices[i].y,
				vertices[i].z,d[i]);
	for (i = nel-1  ; i >= nn ; i-- )
		if (!debug)
       			printf("%g %g %g\n",vertices[i].x,vertices[i].y,vertices[i].z);
		else	 
       			printf("%g %g %g %g\n",vertices[i].x,vertices[i].y,
				vertices[i].z,d[i]);
}
