/*=====================================================================
    structs.h

          defines all global variables and structures.              

  ======================================================================*/

#include <stdio.h>
#include <math.h>

/* Define Boolean type */
typedef int FLAG;
#define TRUE    1
#define FALSE   0

/* Define vertices */
#define X   0
#define Y   1
#define Z   2

#define MAX_INT 2147483647

/* Define structures for vertices, edges and faces */
struct tvertex {
	double v[3];
          int vnum;
          struct tedge *duplicate;
          FLAG active, mark;
          struct tvertex *next, *prev;
          };

struct tedge {
          struct tface *adjface[3];
          struct tvertex *endpts[2];
          FLAG deleted;
          struct tedge *next, *prev;
          };

struct tface {
          struct tedge *edg[3];
          struct tvertex *vert[3];
          FLAG visible;
          double p[3];
          struct tface *next, *prev;
          };

/* Define flags */
#define ACTIVE   1
#define DELETED  1
#define VISIBLE  1
#define MARKED   1

/* Global variable definitions */
#ifdef global
struct tvertex *vertices = NULL;
struct tedge   *edges    = NULL;
struct tface   *faces    = NULL;
FLAG debug = FALSE;
FLAG test  = FALSE;

#else
extern struct tvertex *vertices;
extern struct tedge   *edges;
extern struct tface   *faces;
extern FLAG debug;
extern FLAG test;

#endif
