/*
 * Copyright (c) 1992, The Geometry Center
 *                     University of Minnesota 
 *                     1300 South Second Street
 *                     Minneapolis, MN  55454
 *
 * email address: software@geom.umn.edu
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 *     The National Science and Technology Research Center for
 *      Computation and Visualization of Geometric Structures
 */

/* Generated by Interface Builder */

#import <objc/Object.h>
#import <dpsclient/event.h>
#import <appkit/color.h>
#import <streams/streams.h>

@interface Link:Object
{
  id editBrancher;    /* Global object receives messages from menu */
  id editView;        /* Points to specific EditView for Link */
  id displayView;     /* Points to specific DisplayView for Link */
  id window;          /* Window link is in (this is a delegate for). */
  id graphicBox;      /* Box--superview of current view */
  id notices;         /* Text for help messages to appear in */

  id distributor;     /* init points it to the Distributor object */
  char mode;          /* EDITOR or DISPLAYER or CONWAY */
  id prefObj;         /* Outlet to defaults manager */

  id modeButton;      /* Mode-selecting pop-down list */
  id menu1;           /* Outlets to individual menu cells */
  id menu2;
  id menu3;

  id notationBox;     /* Box whose content view contains the notation interface */
  id notationRB;      /* Either set to Conway or braid */
  id notationText;    /* Text where notation is entered */
  id entryBox;        /* Its content view is notationText */
  id conwayRB;        /* Link or tangle */
  id braidRB;         /* Open or closed */
  id RBBox;           /* Its content view is conwayRB or braidRB */
  
  
  /* Editor link structure variables */
  LinkEditStatus *mygnrc;
  LinkStatus *mylink_status;
  LinkData *mydata;
  char *lastEMessage;

  /* Displayer link structure variables */
  link *linkptr;
  short tangle;
  int *row;
  int **matrix;

  /* Notation variables */
  char conwayType;
  char braidType;

  /*** Current Status Variables ***/
  char currentType;       /* EDITOR, DISPLAYER (matrix), CONWAY, BRAID */
  char isClosed;          /* braid: open or closed; conway: tangle or link */
  const char *name;       /* braid or conway name */

  const char *linkfile;   /* Most recently opened or saved link file name */
  char linkfileType;      /* Most recently opened or saved type */
  
  /* Parameters from inspection panels */

  float amp, ampB, fffa, fffb, ppc, segMax, segScale, sep; /* Displayer */
  char texture, redraw;

  char rulers, arrows, axes, vertices, anchorPoints; /* Editor */
  int sparse;

  float **parameters;                                /* Array of pointers to them */
  

  /*** Conversion variables ***/
  
  BOOL isDirty;       /* YES if link was edited after last
			 time it was displayed */
  char redrawType;    /* Type of last redraw: EVOLUTION, ANCHORS, EVOLUTION_FULL */
  int numcross;       /* Valid after conversion to matrix or linkptr via anchors,
			 or after a file read */
}

- print;
- dumpMatrix;
- imbibeDefaults;
- showInspector:sender;
- (LinkEditStatus *) get_gnrc;
- (LinkStatus *) get_status;
- (LinkData *) get_data;
- printMessage:(char *) s;
- get_editView;
- (char) get_mode;
- get_window;
- (float **) get_parameters;
- (int) get_numcross;
- (short) get_tangle;
- (int **) get_matrix;
- (const char *) get_linkfile;
- (char) get_linkfileType;
- (NXColor *) get_colors;
- setModeEditor:sender;
- setModeDisplayer:sender;
- setModeNotation:sender;
- setNotationConway:sender;
- setNotationBraid:sender;
- (char) whichToDisplay;
- (char) doDraw:sender;
- initEditorSettings;
- init;
- initTitle:(char *) title;
- reflect;
- alternate;
- setEditorMode:(int) mode;

/*** File methods ***/
- setFileInfo:(const char *) filename :(char) file_type;
- saveLinktool:(const char *) filename;
- saveEditor:(const char *) filename;
- loadEditor:(const char *) filename;
- saveMatrix:(const char *) filename;
- loadMatrix:(const char *) filename;
- saveSB:(const char *) filename;
- saveThreeD:(const char *) filename;

/*** Notation methods ***/
- readNotation;
- showNotationHelp:sender;
- (int) checkConway;
- (int) checkBraid:(const char *) s;
- nameProcess;
- convertStringToMatrix: (char *) mstring;

/*** Conversion methods ***/
/* These are used to index matrix */
#define ORNT 0
#define UPN  1
#define UPO  2
#define DNN  3
#define DNO  4
- convertEditToMatrix;
- convertMatrixToLinkptr;
- (BOOL) convertUsingAnchors;
- redrawToEditor;
- drawToStream:(NXStream *) stream;

- activateKeyEq;
- inactivateKeyEq;

/**** Delegate methods ****/

- makeLinkActive;
- makeLinkInactive;
- windowDidBecomeKey:win;
- windowWillResize:win toSize:(NXSize *)frameSize;
- windowDidResignKey:sender;
- textDidChange:sender;

/* Minimum dimensions of window */
#define MINWIDTH   395
#define MINHEIGHT  315

/* Mode constants */
#define EDITOR    0
#define DISPLAYER 1
#define CONWAY    2
#define BRAID     3

/* Conway constants */
#define LINK   0
#define TANGLE 1

/* Displayer inspector radio button tags */
#define ROPE       0
#define CURVE      1
#define BORDERED_H 2
#define BORDERED_F 3

#define EVOLUTION       0
#define ANCHORS         1
#define EVOLUTION_FULL  2

#define NUM_LOCAL_SETTINGS 16

@end
