/*
 * Copyright (c) 1992, The Geometry Center
 *                     University of Minnesota 
 *                     1300 South Second Street
 *                     Minneapolis, MN  55454
 *
 * email address: software@geom.umn.edu
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 *     The National Science and Technology Research Center for
 *      Computation and Visualization of Geometric Structures
 */


/* Generated by Interface Builder */

#import <appkit/View.h>

@interface DisplayView:View
{
  float scaleToSquare, lscaleToSquare;
  float xoffset, yoffset, lxoffset, lyoffset;
  float height, width;   /* height & width of each rectangle */
  
  /* Display parameters */
  float amp, ampB, fffa, fffb, ppc, segMax, segScale, sep;
  char texture, redraw;
  int sparse;
  float **values;           /* Array of pointers to display parameters */
  float locamplitude;       /* This is the adjusted amplitude if more than one
			       link is displayed at once */
  float locpixelsPerCycle;  /* ditto for this */
  
  id linkObj;           /* Link object it's for */
}

- (BOOL) acceptsFirstResponder;
- copy:sender;
- drawCircle;
- drawSelf: (NXRect *)dRects:(int)dCount;
- linkdraw :(link *) linkptr :(FILE *) ofp :(LinkStatus *) gnrc;
- splineEmUp :(int) segs :(FILE *) ofp :(LinkStatus *) gnrc
  :(double *) rope :(float *) lastx :(float *) lasty :(int) j :(int) n
  :(double [500][2]) p :(float *) x :(float *) y
  :(double [2]) x0 :(double [2]) x1 :(double [2]) x2 :(double [2]) x3;
- setColor: (int) strand;
- drawLine :(float) x1 :(float) y1 :(float) x2 :(float) y2
  :(double *) rope :(float *) lastx :(float *) lasty :(int) m :(int) n;
- drawPolygon :(int) segs :(float *) x :(float *) y : (double *) rope
  : (float *) lastx :(float *) lasty :(int) m :(int) n;
- clearScreen;
- setScale;
- (BOOL) knowsPagesFirst: (int *) f last: (int *) l;
- (BOOL) getRect: (NXRect *)r forPage :(int) page;
- initFrame:(const NXRect *)frameRect;
/* Display parameters */
- setLink:(id) linkO;
- (float **) getValues;

@end
