/*****************************************************************
 * idiff.c: FBM Release 1.0 25-Feb-90 Michael Mauldin
 *
 * Copyright (C) 1989,1990 by Michael Mauldin.  Permission is granted
 * to use this file in whole or in part for any purpose, educational,
 * recreational or commercial, provided that this copyright notice
 * is retained unchanged.  This software is available to all free of
 * charge by anonymous FTP and in the UUNET archives.
 *
 * idiff.c: 
 *
 * USAGE
 *	% idiff [ flags ] arguments
 *
 * EDITLOG
 *	LastEditDate = Mon Jun 25 00:18:20 1990 - Michael Mauldin
 *	LastFileName = /usr2/mlm/src/misc/fbm/idiff.c
 *
 * HISTORY
 * 25-Jun-90  Michael Mauldin (mlm@cs.cmu.edu) Carnegie Mellon
 *	Package for Release 1.0
 *
 * 07-Mar-89  Michael Mauldin (mlm) at Carnegie Mellon University
 *	Beta release (version 0.9) mlm@cs.cmu.edu
 *
 * 18-Aug-88  Michael Mauldin (mlm) at Carnegie-Mellon University
 *	Created.
 *****************************************************************/

# include <stdio.h>

# define USAGE \
"Usage: idiff < original > delta\n       udiff < delta > original"

#ifndef lint
static char *fbmid =
"$FBM idiff.c <1.0> 25-Jun-90  (C) 1989,1990 by Michael Mauldin, source \
code available free from MLM@CS.CMU.EDU and from UUNET archives$";
#endif

main (argc, argv)
char *argv[];
{ register int ch, lastch=0;

  if (argc > 1 || !strcmp (argv[0] + strlen (argv[0]) - 5, "udiff"))
  { while ((ch = getchar ()) != EOF)
    { putchar (lastch = ((ch+lastch) & 255)); }
  }
  else
  { while ((ch = getchar ()) != EOF)
    { putchar ((ch-lastch) & 255);
      lastch = ch;
    }
  }
}
